/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.beans.serialization.impl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openmetadata.beans.IdentifiableBean;
import org.openmetadata.beans.serialization.Populator;
import org.openmetadata.beans.serialization.Serializer;
import org.openmetadata.beans.serialization.SourceCaster;
import org.openmetadata.beans.serialization.SourceInitializer;

public class SerializerImpl<Source>
implements Serializer<Source> {
    protected Log logger = LogFactory.getLog(this.getClass());
    private SourceCaster<Source> sourceCaster;
    private SourceInitializer<Source> sourceInitializer;
    private Populator<Source> populator;

    @Override
    public <S extends Source> S serialize(Class<S> sourceClass, IdentifiableBean bean) {
        Source source = this.getSourceInitializer().initializeSource(sourceClass, bean);
        this.serialize(source, bean);
        return this.getSourceCaster().castSource(sourceClass, source);
    }

    @Override
    public void serialize(Source source, IdentifiableBean bean) {
        this.getPopulator().populate(source, bean);
    }

    @Override
    public Class<? extends Source> getSourceClass(IdentifiableBean bean) {
        return null;
    }

    public void setPopulator(Populator<Source> populator) {
        if (this.populator != null && !this.populator.equals(populator)) {
            String msg = "Populator cannot be reset.";
            this.logger.error((Object)msg);
            throw new RuntimeException(msg);
        }
        this.populator = populator;
    }

    public void setSourceCaster(SourceCaster<Source> sourceCaster) {
        if (this.sourceCaster != null && !this.sourceCaster.equals(sourceCaster)) {
            String msg = "Source caster cannot be reset.";
            this.logger.error((Object)msg);
            throw new RuntimeException(msg);
        }
        this.sourceCaster = sourceCaster;
    }

    public void setSourceInitializer(SourceInitializer<Source> sourceInitializer) {
        if (this.sourceInitializer != null && !this.sourceInitializer.equals(sourceInitializer)) {
            String msg = "Source initializer cannot be reset.";
            this.logger.error((Object)msg);
            throw new RuntimeException(msg);
        }
        this.sourceInitializer = sourceInitializer;
    }

    protected final Populator<Source> getPopulator() {
        if (this.populator == null) {
            String msg = "Populator has not been set.";
            this.logger.error((Object)msg);
            throw new RuntimeException(msg);
        }
        return this.populator;
    }

    protected final SourceCaster<Source> getSourceCaster() {
        if (this.sourceCaster == null) {
            String msg = "Source caster has not been set.";
            this.logger.error((Object)msg);
            throw new RuntimeException(msg);
        }
        return this.sourceCaster;
    }

    protected final SourceInitializer<Source> getSourceInitializer() {
        if (this.sourceInitializer == null) {
            String msg = "Source initializer has not been set.";
            this.logger.error((Object)msg);
            throw new RuntimeException(msg);
        }
        return this.sourceInitializer;
    }
}

