/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.beans.paging.impl;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.HashSet;
import org.openmetadata.beans.IdentifiableBean;
import org.openmetadata.beans.exceptions.PaginationException;
import org.openmetadata.beans.exceptions.ResolverException;
import org.openmetadata.beans.paging.PaginationListener;
import org.openmetadata.beans.paging.Paginator;
import org.openmetadata.beans.reference.Resolver;

public class PaginatorImpl<B extends IdentifiableBean>
implements Paginator<B> {
    protected final Class<B> beanClass;
    protected final Resolver resolver;
    protected final int pageSize;
    protected final String[] identifiers;
    protected final int totalPages;
    protected final boolean isComplete;
    protected final HashSet<PaginationListener> listeners;
    protected int currentPage;
    protected B[] pageItems;

    public PaginatorImpl(Class<B> beanClass, Resolver resolver, int pageSize, boolean isComplete, String ... identifiers) {
        this.beanClass = beanClass;
        this.resolver = resolver;
        this.pageSize = pageSize <= 0 ? identifiers.length : pageSize;
        this.isComplete = isComplete;
        this.identifiers = identifiers;
        this.totalPages = (int)Math.ceil((double)identifiers.length / (double)this.pageSize);
        this.listeners = new HashSet();
        this.currentPage = 0;
    }

    @Override
    public String[] getAllIdentifiers() {
        return Arrays.copyOf(this.identifiers, this.identifiers.length);
    }

    @Override
    public B[] getCurrentPageItems() {
        if (this.pageItems == null) {
            this.buildPage(1);
        }
        return this.pageItems;
    }

    @Override
    public int getTotalItemCount() {
        return this.identifiers.length;
    }

    @Override
    public int getItemCountPerPage() {
        return this.pageSize;
    }

    @Override
    public int getCurrentItemCount() {
        if (this.pageItems == null) {
            this.buildPage(1);
        }
        return this.pageItems.length;
    }

    @Override
    public int getCurrentPageNumber() {
        return this.currentPage;
    }

    @Override
    public int getTotalPageCount() {
        return this.totalPages;
    }

    @Override
    public boolean hasNextPage() {
        return this.currentPage < this.totalPages;
    }

    @Override
    public boolean hasPreviousPage() {
        return this.currentPage > 1;
    }

    @Override
    public B[] goToPage(int pageNumber) throws PaginationException {
        this.checkPage(pageNumber);
        this.buildPage(pageNumber);
        return this.pageItems;
    }

    @Override
    public B[] goToNextPage() throws PaginationException {
        this.checkPage(++this.currentPage);
        this.buildPage(this.currentPage);
        return this.pageItems;
    }

    @Override
    public B[] goToPreviousPage() throws PaginationException {
        this.checkPage(--this.currentPage);
        this.buildPage(this.currentPage);
        return this.pageItems;
    }

    @Override
    public B[] goToFirstPage() {
        this.buildPage(1);
        return this.pageItems;
    }

    @Override
    public B[] goToLastPage() {
        this.buildPage(this.totalPages);
        return this.pageItems;
    }

    @Override
    public boolean isComplete() {
        return this.isComplete;
    }

    @Override
    public void addPaginatorListener(PaginationListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removePaginationListener(PaginationListener listener) {
        this.listeners.remove(listener);
    }

    protected void buildPage(int page) {
        int max;
        int n = max = this.identifiers.length > 0 ? this.pageSize : 0;
        if (page == this.getTotalPageCount() && max != 0) {
            max = this.identifiers.length - this.pageSize * (page - 1);
        }
        this.pageItems = (IdentifiableBean[])Array.newInstance(this.beanClass, max);
        int i = 0;
        while (i < max) {
            try {
                this.pageItems[i] = this.resolver.resolve(this.beanClass, this.identifiers[(page - 1) * this.pageSize + i]);
            }
            catch (ResolverException e) {
                throw new RuntimeException(e);
            }
            ++i;
        }
        this.currentPage = page;
        for (PaginationListener listener : this.listeners) {
            listener.notifyPageChange(page);
        }
    }

    private void checkPage(int pageNumber) throws PaginationException {
        if (pageNumber > this.totalPages || pageNumber < 1) {
            throw new PaginationException("Invalid page number (" + pageNumber + "). Valid values are 1 - " + this.totalPages + ".");
        }
    }
}

