/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.beans.notification.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.openmetadata.beans.IdentifiableBean;
import org.openmetadata.beans.notification.ChangeEvent;
import org.openmetadata.beans.notification.IdentifiableChangeEvent;

public final class ConsolidatedEvent
implements IdentifiableChangeEvent {
    private final IdentifiableBean bean;
    private final HashSet<String> newReferences;
    private final HashSet<String> removedReferences;
    private final ArrayList<ChangeEvent> events;
    private ChangeEvent.Type type;

    public ConsolidatedEvent(IdentifiableBean bean) {
        this.bean = bean;
        this.newReferences = new HashSet();
        this.removedReferences = new HashSet();
        this.events = new ArrayList();
        this.type = ChangeEvent.Type.UPDATE;
    }

    @Override
    public IdentifiableBean getBean() {
        return this.bean;
    }

    @Override
    public ChangeEvent[] getInitiatingEvents() {
        return this.events.toArray(new ChangeEvent[0]);
    }

    @Override
    public Set<String> getNewReferences() {
        return this.newReferences;
    }

    @Override
    public Set<String> getRemovedReferences() {
        return this.removedReferences;
    }

    @Override
    public ChangeEvent.Type getType() {
        return this.type;
    }

    public void addEvent(IdentifiableChangeEvent event) {
        this.events.add(event);
        this.addReferences(event.getNewReferences());
        this.removeReferences(event.getRemovedReferences());
        if (event.getType().equals((Object)ChangeEvent.Type.DELETE) || event.getType().equals((Object)ChangeEvent.Type.CREATE)) {
            this.type = event.getType();
        }
    }

    private void addReferences(Set<String> references) {
        this.newReferences.addAll(references);
        this.removedReferences.removeAll(references);
    }

    private void removeReferences(Set<String> references) {
        this.removedReferences.addAll(references);
        this.newReferences.removeAll(references);
    }
}

