/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.beans.impl;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.openmetadata.beans.IdentifiableBean;
import org.openmetadata.beans.impl.IdentifiableBeanImpl;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.beans.notification.ChangeEvent;
import org.openmetadata.beans.notification.ChangeListener;
import org.openmetadata.beans.notification.IdentifiableChangeEvent;
import org.openmetadata.beans.notification.IdentifiableChangeListener;
import org.openmetadata.beans.notification.impl.CreationEvent;
import org.openmetadata.beans.notification.impl.IdentifiableChangeEventImpl;

public abstract class MutableIdentifiableBeanImpl
extends IdentifiableBeanImpl
implements IdentifiableBean,
ChangeListener {
    protected boolean collectLocalEvents = true;
    private final IdentifiableChangeListener identifiableChangeListener;
    private LinkedHashSet<IdentifiableChangeEvent> localEventCollection;
    private boolean creationRaised = false;

    protected MutableIdentifiableBeanImpl(boolean newInstance, String id, MutableBeanInitializer initializer) {
        this(newInstance, id, id, initializer);
    }

    protected MutableIdentifiableBeanImpl(boolean newInstance, String id, String containerId, MutableBeanInitializer initializer) {
        super(id, containerId, initializer);
        this.identifiableChangeListener = initializer;
        this.localEventCollection = new LinkedHashSet();
        if (newInstance) {
            this.notifyCreate();
        }
        this.collectLocalEvents = false;
    }

    @Override
    public final void notifyChange(ChangeEvent event) {
        this.sendNotification(new IdentifiableChangeEventImpl(ChangeEvent.Type.UPDATE, (IdentifiableBean)this, this.getReferenceAdditions(event), this.getReferenceDeletions(event), event));
    }

    public boolean verifyInitializer(MutableBeanInitializer initializer) {
        return this.identifiableChangeListener.equals(initializer) && super.verifyInitializer(initializer);
    }

    protected final void change() {
        this.change(new HashSet<String>(), new HashSet<String>());
    }

    protected final void change(Set<String> referenceAdditions, Set<String> referenceDeletions) {
        this.sendNotification(new IdentifiableChangeEventImpl(ChangeEvent.Type.UPDATE, (IdentifiableBean)this, referenceAdditions, referenceDeletions, new ChangeEvent[0]));
    }

    protected final void notifyDelete() {
        this.sendNotification(new IdentifiableChangeEventImpl(ChangeEvent.Type.DELETE, (IdentifiableBean)this, new HashSet<String>(), new HashSet<String>(), new ChangeEvent[0]));
    }

    protected final void notifyCreate() {
        if (!this.creationRaised) {
            this.sendNotification(new CreationEvent(this));
            this.creationRaised = true;
        }
    }

    protected final void purgeLocalEvents() {
        for (IdentifiableChangeEvent event : this.localEventCollection) {
            this.handleChange(event);
        }
        this.localEventCollection.clear();
    }

    protected abstract Set<String> getReferenceAdditions(ChangeEvent var1);

    protected abstract Set<String> getReferenceDeletions(ChangeEvent var1);

    protected abstract void handleChange(IdentifiableChangeEvent var1);

    private final void sendNotification(IdentifiableChangeEvent event) {
        this.identifiableChangeListener.notifyChangeEvent(event);
        if (this.collectLocalEvents) {
            this.localEventCollection.add(event);
        } else {
            this.handleChange(event);
        }
    }
}

