/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.beans.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openmetadata.beans.IdentifiableBean;
import org.openmetadata.beans.MutableBeanCreator;
import org.openmetadata.beans.impl.BeanInitializer;
import org.openmetadata.beans.notification.IdentifiableChangeEvent;
import org.openmetadata.beans.notification.IdentifiableChangeListener;
import org.openmetadata.beans.notification.impl.ConsolidatedEvent;

public abstract class MutableBeanInitializer
extends BeanInitializer
implements MutableBeanCreator,
IdentifiableChangeListener {
    protected Log logger = LogFactory.getLog(this.getClass());
    private ThreadLocal<Boolean> canNotify = new ThreadLocal();
    private ThreadLocal<Boolean> collectChangeEvents = new ThreadLocal();
    private ThreadLocal<LinkedHashMap<IdentifiableBean, ConsolidatedEvent>> eventMap = new ThreadLocal();
    private IdentifiableChangeListener identifiableChangeListener;

    @Override
    public void setChangeListener(IdentifiableChangeListener identifiableChangeListener) {
        if (this.identifiableChangeListener != null && !this.identifiableChangeListener.equals(identifiableChangeListener)) {
            throw new RuntimeException("ChangeListener cannot be reset.");
        }
        this.identifiableChangeListener = identifiableChangeListener;
    }

    @Override
    public final void notifyChangeEvent(IdentifiableChangeEvent event) {
        if (this.canNotify()) {
            if (this.collectChangeEvents()) {
                this.collectChangeEvent(event);
            } else {
                this.getIdentifiableChangeListener().notifyChangeEvent(event);
            }
        }
    }

    protected final IdentifiableChangeListener getIdentifiableChangeListener() {
        if (this.identifiableChangeListener == null) {
            this.logger.error((Object)"ChangeListener not set.");
            throw new RuntimeException("ChangeListener is not set.");
        }
        return this.identifiableChangeListener;
    }

    protected final boolean canNotify() {
        return this.canNotify.get() == null ? true : this.canNotify.get();
    }

    protected final boolean collectChangeEvents() {
        return this.collectChangeEvents.get() == null ? false : this.collectChangeEvents.get();
    }

    protected final void setCanNotify(boolean canNotify) {
        this.canNotify.set(canNotify);
    }

    protected final void setCollectChangeEvents(boolean collectChangeEvents) {
        this.collectChangeEvents.set(collectChangeEvents);
        if (collectChangeEvents && this.eventMap.get() == null) {
            this.eventMap.set(new LinkedHashMap());
        }
    }

    protected final void collectChangeEvent(IdentifiableChangeEvent event) {
        HashMap _eventMap = this.eventMap.get();
        ConsolidatedEvent updateEvent = _eventMap.containsKey(event.getBean()) ? (ConsolidatedEvent)_eventMap.get(event.getBean()) : new ConsolidatedEvent(event.getBean());
        updateEvent.addEvent(event);
        _eventMap.put(updateEvent.getBean(), updateEvent);
    }

    protected ConsolidatedEvent getConsolidatedEvent(IdentifiableBean bean) {
        LinkedHashMap<IdentifiableBean, ConsolidatedEvent> map = this.eventMap.get();
        if (map == null) {
            map = new LinkedHashMap();
            this.eventMap.set(map);
        }
        ConsolidatedEvent event = new ConsolidatedEvent(bean);
        if (map.containsKey(bean)) {
            event = map.get(bean);
            map.remove(bean);
        }
        return event;
    }

    protected Collection<ConsolidatedEvent> getConsolidatedEvents() {
        ArrayList<ConsolidatedEvent> events = new ArrayList<ConsolidatedEvent>();
        if (this.eventMap.get() != null) {
            events.addAll(this.eventMap.get().values());
            this.eventMap.get().clear();
        }
        return events;
    }
}

