/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.beans.impl;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.openmetadata.beans.KeyedBean;
import org.openmetadata.beans.KeyedValueBean;
import org.openmetadata.beans.impl.BeanImpl;
import org.openmetadata.beans.notification.ChangeListener;

public abstract class KeyedValueBeanImpl<B extends KeyedBean>
extends BeanImpl
implements KeyedValueBean<B> {
    private final Class<B> beanClass;
    private Map<Map<Enum<?>, Object>, B> map = new LinkedHashMap();

    protected abstract B createNewBean(Map<Enum<?>, Object> var1);

    protected KeyedValueBeanImpl(Class<B> beanClass, ChangeListener changeListener) {
        super(changeListener);
        this.beanClass = beanClass;
    }

    @Override
    public B getBean(Map<Enum<?>, Object> keys) {
        if (this.map.containsKey(keys)) {
            return (B)((KeyedBean)this.map.get(keys));
        }
        B newBean = this.createNewBean(keys);
        this.map.put(keys, newBean);
        return newBean;
    }

    @Override
    public B[] findBeans(Map<Enum<?>, Object> query) {
        ArrayList<KeyedBean> tmpList = new ArrayList<KeyedBean>();
        for (Map<Enum<?>, Object> myKeys : this.map.keySet()) {
            if (!myKeys.entrySet().containsAll(query.entrySet())) continue;
            KeyedBean bean = (KeyedBean)this.map.get(myKeys);
            tmpList.add(bean);
        }
        return tmpList.toArray((KeyedBean[])Array.newInstance(this.beanClass, 0));
    }

    @Override
    public void remove(Map<Enum<?>, Object> keys) {
        this.map.remove(keys);
    }

    @Override
    public void removeAll(Map<Enum<?>, Object> query) {
        HashSet keysMapToRemove = new HashSet();
        for (Map<Enum<?>, Object> map : this.map.keySet()) {
            if (!map.entrySet().containsAll(query.entrySet())) continue;
            keysMapToRemove.add(map);
        }
        for (Map<Enum, Object> map : keysMapToRemove) {
            this.map.remove(map);
        }
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public B[] getAllValues() {
        return this.map.values().toArray((KeyedBean[])Array.newInstance(this.beanClass, 0));
    }
}

