/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.beans.impl;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.openmetadata.beans.BeanList;
import org.openmetadata.beans.impl.BeanImpl;
import org.openmetadata.beans.notification.ChangeListener;

public abstract class BeanListImpl<B>
extends BeanImpl
implements BeanList<B> {
    private final List<B> list = new ArrayList<B>();
    private final Class<B> beanClass;

    protected abstract B createNew();

    public BeanListImpl(Class<B> beanClass, ChangeListener changeListener) {
        super(changeListener);
        this.beanClass = beanClass;
    }

    @Override
    public B addNew() {
        B newBean = this.createNew();
        this.list.add(newBean);
        this.change();
        return newBean;
    }

    protected List<B> getInternalList() {
        return this.list;
    }

    protected boolean add(B bean) {
        boolean returnedVal = this.list.add(bean);
        if (returnedVal) {
            this.change();
        }
        return returnedVal;
    }

    @Override
    public boolean contains(B bean) {
        return this.list.contains(bean);
    }

    @Override
    public Iterator<B> iterator() {
        return this.list.iterator();
    }

    @Override
    public boolean remove(B bean) {
        boolean isRemoved = this.list.remove(bean);
        if (isRemoved) {
            this.change();
        }
        return isRemoved;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public void moveBefore(B move, B before) {
        if (move == before) {
            return;
        }
        if (this.list.contains(move) && this.list.contains(before)) {
            this.list.remove(move);
            int beforeIndex = this.list.lastIndexOf(before);
            this.list.add(beforeIndex, move);
            this.change();
        }
    }

    @Override
    public void moveAfter(B move, B after) {
        if (move != after && this.list.contains(move) && this.list.contains(after)) {
            this.list.remove(move);
            int afterIndex = this.list.lastIndexOf(after);
            if (afterIndex < this.list.size() - 1) {
                this.list.add(afterIndex + 1, move);
            } else {
                this.list.add(move);
            }
            this.change();
        }
    }

    @Override
    public void sort(Comparator<B> comparator) {
        Collections.sort(this.list, comparator);
        this.change();
    }

    @Override
    public B[] toArray() {
        Object[] typeArr = (Object[])Array.newInstance(this.beanClass, 0);
        return this.list.toArray(typeArr);
    }

    protected Class<? extends B> getBeanClass() {
        return this.beanClass;
    }
}

