/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.beans.impl;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openmetadata.beans.BeanCreator;
import org.openmetadata.beans.IdentifiableBean;
import org.openmetadata.beans.exceptions.ResolverException;
import org.openmetadata.beans.reference.Resolver;

public abstract class BeanInitializer
implements BeanCreator,
Resolver {
    private Resolver resolver;
    protected Log logger = LogFactory.getLog(this.getClass());

    @Override
    public void setResolver(Resolver resolver) {
        if (this.resolver != null && !this.resolver.equals(resolver)) {
            throw new RuntimeException("Resolver cannot be reset.");
        }
        this.resolver = resolver;
    }

    @Override
    public final Set<String> getReferrers(String id) {
        return this.getResolver().getReferrers(id);
    }

    @Override
    public final <B extends IdentifiableBean> B resolve(Class<B> beanClass, String id) throws ResolverException {
        return this.getResolver().resolve(beanClass, id);
    }

    @Override
    public final <B extends IdentifiableBean> Set<B> resolve(Class<B> beanClass, Set<String> ids) throws ResolverException {
        return this.getResolver().resolve(beanClass, ids);
    }

    protected final Resolver getResolver() {
        if (this.resolver == null) {
            this.logger.error((Object)"Resolver not set.");
            throw new RuntimeException("Resolver is not set.");
        }
        return this.resolver;
    }

    protected final <B extends IdentifiableBean> B castBean(Class<B> beanClass, IdentifiableBean bean) {
        if (!beanClass.isAssignableFrom(bean.getClass())) {
            String msg = "The bean of type, " + bean.getClass().getCanonicalName() + ", cannot be converted to the type, " + beanClass.getCanonicalName() + ".";
            this.logger.error((Object)msg);
            throw new RuntimeException(msg);
        }
        return (B)((IdentifiableBean)beanClass.cast(bean));
    }
}

