/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.beans.factory.impl;

import org.openmetadata.beans.IdentifiableBean;
import org.openmetadata.beans.factory.BeanFactory;
import org.openmetadata.beans.factory.ImplementationConstructor;
import org.openmetadata.beans.impl.IdentifiableBeanImpl;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.beans.notification.ChangeEvent;
import org.openmetadata.beans.notification.impl.ConsolidatedEvent;
import org.openmetadata.beans.notification.impl.CreationEvent;

public class BeanFactoryImpl
extends MutableBeanInitializer
implements BeanFactory {
    private ImplementationConstructor implementationConstructor;

    @Override
    public final <B extends IdentifiableBean> B newInstance(Class<B> beanClass) {
        this.setCollectChangeEvents(true);
        IdentifiableBeanImpl bean = this.getImplementationConstructor().constructImplementation(beanClass);
        if (!bean.verifyInitializer(this)) {
            throw new RuntimeException("Bean was not constructed properly: initializer has not been set as expected.");
        }
        this.setCollectChangeEvents(false);
        ConsolidatedEvent beanEvent = this.getConsolidatedEvent(bean);
        if (!beanEvent.getType().equals((Object)ChangeEvent.Type.CREATE)) {
            beanEvent.addEvent(new CreationEvent(bean));
        }
        this.notifyChangeEvent(beanEvent);
        for (ConsolidatedEvent event : this.getConsolidatedEvents()) {
            this.notifyChangeEvent(event);
        }
        return this.castBean(beanClass, bean);
    }

    public void setImplementationConstructor(ImplementationConstructor implementationConstructor) {
        if (this.implementationConstructor != null && !this.implementationConstructor.equals(implementationConstructor)) {
            String msg = "Implementation constructor cannot be reset.";
            this.logger.error((Object)msg);
            throw new RuntimeException(msg);
        }
        this.implementationConstructor = implementationConstructor;
    }

    protected final ImplementationConstructor getImplementationConstructor() {
        if (this.implementationConstructor == null) {
            String msg = "ImplementationConstructor has not been set.";
            this.logger.error((Object)msg);
            throw new RuntimeException(msg);
        }
        return this.implementationConstructor;
    }
}

