/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.beans.deserialization.impl;

import org.openmetadata.beans.IdentifiableBean;
import org.openmetadata.beans.deserialization.ImplementationConstructor;
import org.openmetadata.beans.deserialization.MutableDeserializer;
import org.openmetadata.beans.deserialization.Populator;
import org.openmetadata.beans.impl.IdentifiableBeanImpl;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.beans.notification.impl.ConsolidatedEvent;

public class MutableDeserializerImpl<Source>
extends MutableBeanInitializer
implements MutableDeserializer<Source> {
    private Populator<Source> populator;
    private ImplementationConstructor<Source> implementationConstructor;

    @Override
    public final <B extends IdentifiableBean> B deserialize(Class<B> beanClass, Source source) {
        BlankDeserializerRunner runner = new BlankDeserializerRunner(beanClass, source);
        Thread t = new Thread(runner);
        t.start();
        try {
            t.join();
            return (B)runner.getBean();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final void deserialize(IdentifiableBean bean, Source source) {
        ReserializerRunner runner = new ReserializerRunner(bean, source);
        Thread t = new Thread(runner);
        t.start();
        try {
            t.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void setPopulator(Populator<Source> populator) {
        if (this.populator != null && !this.populator.equals(populator)) {
            String msg = "Populator cannot be reset.";
            this.logger.error((Object)msg);
            throw new RuntimeException(msg);
        }
        this.populator = populator;
    }

    public void setImplementationConstructor(ImplementationConstructor<Source> implementationConstructor) {
        if (this.implementationConstructor != null && !this.implementationConstructor.equals(implementationConstructor)) {
            String msg = "Implementation constructor cannot be reset.";
            this.logger.error((Object)msg);
            throw new RuntimeException(msg);
        }
        this.implementationConstructor = implementationConstructor;
    }

    protected final Populator<Source> getPopulator() {
        if (this.populator == null) {
            String msg = "Populator has not been set.";
            this.logger.error((Object)msg);
            throw new RuntimeException(msg);
        }
        return this.populator;
    }

    protected final ImplementationConstructor<Source> getImplementationConstructor() {
        if (this.implementationConstructor == null) {
            String msg = "ImplementationConstructor has not been set.";
            this.logger.error((Object)msg);
            throw new RuntimeException(msg);
        }
        return this.implementationConstructor;
    }

    private final class BlankDeserializerRunner<B extends IdentifiableBean>
    implements Runnable {
        private final Class<B> beanClass;
        private final Source source;
        private IdentifiableBeanImpl bean;

        private BlankDeserializerRunner(Class<B> beanClass, Source source) {
            this.beanClass = beanClass;
            this.source = source;
        }

        @Override
        public void run() {
            MutableDeserializerImpl.this.setCanNotify(false);
            this.bean = MutableDeserializerImpl.this.getImplementationConstructor().constructImplementation(this.beanClass, this.source);
            if (!this.bean.verifyInitializer(MutableDeserializerImpl.this)) {
                throw new RuntimeException("Bean was not constructed properly: initializer has not been set as expected.");
            }
            MutableDeserializerImpl.this.getPopulator().populate(this.bean, this.source);
            MutableDeserializerImpl.this.setCanNotify(true);
        }

        private B getBean() {
            return (B)MutableDeserializerImpl.this.castBean(this.beanClass, this.bean);
        }
    }

    private final class ReserializerRunner
    implements Runnable {
        private IdentifiableBean bean;
        private final Source source;

        private ReserializerRunner(IdentifiableBean bean, Source source) {
            this.bean = bean;
            this.source = source;
        }

        @Override
        public void run() {
            MutableDeserializerImpl.this.setCollectChangeEvents(true);
            MutableDeserializerImpl.this.getPopulator().populate(this.bean, this.source);
            MutableDeserializerImpl.this.setCollectChangeEvents(false);
            for (ConsolidatedEvent event : MutableDeserializerImpl.this.getConsolidatedEvents()) {
                MutableDeserializerImpl.this.notifyChangeEvent(event);
            }
        }
    }
}

