/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.beans.deserialization.impl;

import org.openmetadata.beans.IdentifiableBean;
import org.openmetadata.beans.deserialization.Deserializer;
import org.openmetadata.beans.deserialization.ImplementationConstructor;
import org.openmetadata.beans.deserialization.Populator;
import org.openmetadata.beans.impl.BeanInitializer;
import org.openmetadata.beans.impl.IdentifiableBeanImpl;

public class DeserializerImpl<Source>
extends BeanInitializer
implements Deserializer<Source> {
    private Populator<Source> populator;
    private ImplementationConstructor<Source> implementationConstructor;

    @Override
    public <B extends IdentifiableBean> B deserialize(Class<B> beanClass, Source source) {
        IdentifiableBeanImpl bean = this.getImplementationConstructor().constructImplementation(beanClass, source);
        if (!bean.verifyInitializer(this)) {
            throw new RuntimeException("Bean was not constructed properly: initializer has not been set as expected.");
        }
        this.getPopulator().populate(bean, source);
        return this.castBean(beanClass, bean);
    }

    public void setPopulator(Populator<Source> populator) {
        if (this.populator != null && !this.populator.equals(populator)) {
            String msg = "Populator cannot be reset.";
            this.logger.error((Object)msg);
            throw new RuntimeException(msg);
        }
        this.populator = populator;
    }

    public void setImplementationConstructor(ImplementationConstructor<Source> implementationConstructor) {
        if (this.implementationConstructor != null && !this.implementationConstructor.equals(implementationConstructor)) {
            String msg = "Implementation constructor cannot be reset.";
            this.logger.error((Object)msg);
            throw new RuntimeException(msg);
        }
        this.implementationConstructor = implementationConstructor;
    }

    protected final Populator<Source> getPopulator() {
        if (this.populator == null) {
            String msg = "Populator has not been set.";
            this.logger.error((Object)msg);
            throw new RuntimeException(msg);
        }
        return this.populator;
    }

    protected final ImplementationConstructor<Source> getImplementationConstructor() {
        if (this.implementationConstructor == null) {
            String msg = "ImplementationConstructor has not been set.";
            this.logger.error((Object)msg);
            throw new RuntimeException(msg);
        }
        return this.implementationConstructor;
    }
}

