/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.beans.serialization.xml;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.openmetadata.beans.IdentifiableBean;
import org.openmetadata.beans.serialization.SourceInitializer;
import org.openmetadata.beans.serialization.xml.SchemaTypeFinder;
import org.openmetadata.store.exceptions.ObjectNotFoundException;
import org.openmetadata.store.repository.Repository;
import org.openmetadata.util.xmlbeans.XmlObjectCaster;

public class XmlObjectInitializer<X extends XmlObject>
implements SourceInitializer<X> {
    protected Log logger = LogFactory.getLog(this.getClass());
    private SchemaTypeFinder schemaTypeFinder;
    private Repository<X> repository;
    private XmlOptions xmlOptions;
    private boolean hasRepository;

    public X initializeSource(Class<? extends X> targetClass, IdentifiableBean bean) {
        SchemaType schemaType = this.getSchemaTypeFinder().findSchemaType(targetClass, bean);
        if (this.hasRepository) {
            Repository<X> repository = this.getRepository();
            try {
                XmlObject source = (XmlObject)repository.get(bean.getPrimaryIdentifier());
                return (X)XmlObjectCaster.cast(targetClass, (XmlObject)source);
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                // empty catch block
            }
        }
        return (X)XmlObjectCaster.cast(targetClass, (XmlObject)XmlBeans.getContextTypeLoader().newInstance(schemaType, this.xmlOptions));
    }

    public void setRepository(Repository<X> repository) {
        if (this.repository != null && !this.repository.equals(repository)) {
            String msg = "Repository cannot be reset.";
            this.logger.error((Object)msg);
            throw new RuntimeException(msg);
        }
        this.repository = repository;
        this.hasRepository = true;
    }

    public void setSchemaTypeFinder(SchemaTypeFinder schemaTypeFinder) {
        if (this.schemaTypeFinder != null && !this.schemaTypeFinder.equals(schemaTypeFinder)) {
            String msg = "Schema type finder cannot be reset.";
            this.logger.error((Object)msg);
            throw new RuntimeException(msg);
        }
        this.schemaTypeFinder = schemaTypeFinder;
    }

    protected final Repository<X> getRepository() {
        if (this.repository == null) {
            String msg = "Repository has not been set.";
            this.logger.error((Object)msg);
            throw new RuntimeException(msg);
        }
        return this.repository;
    }

    protected final SchemaTypeFinder getSchemaTypeFinder() {
        if (this.schemaTypeFinder == null) {
            String msg = "Schema type finder has not been set.";
            this.logger.error((Object)msg);
            throw new RuntimeException(msg);
        }
        return this.schemaTypeFinder;
    }
}

