/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.beans.serialization.xml;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.openmetadata.beans.IdentifiableBean;
import org.openmetadata.beans.serialization.SourceInitializer;
import org.openmetadata.beans.serialization.xml.SchemaTypeFinder;
import org.openmetadata.beans.serialization.xml.XmlObjectCaster;
import org.openmetadata.store.exceptions.ObjectNotFoundException;
import org.openmetadata.store.repository.Repository;

public class XmlOjbectInitializer
implements SourceInitializer<XmlObject> {
    protected Log logger = LogFactory.getLog(this.getClass());
    private SchemaTypeFinder schemaTypeFinder;
    private Repository<XmlObject> repository;
    private XmlObjectCaster xmlObjectCaster;
    private XmlOptions xmlOptions;
    private boolean hasRepository;

    public XmlObject initializeSource(Class<? extends XmlObject> targetClass, IdentifiableBean bean) {
        SchemaType schemaType = this.getSchemaTypeFinder().findSchemaType(targetClass, bean);
        if (this.hasRepository) {
            Repository<XmlObject> repository = this.getRepository();
            try {
                XmlObject source = (XmlObject)repository.get(bean.getPrimaryIdentifier());
                XmlObjectCaster xmlObjectCaster = this.getXmlObjectCaster();
                if (xmlObjectCaster.canCast(targetClass, source)) {
                    return xmlObjectCaster.castSource(targetClass, source);
                }
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                // empty catch block
            }
        }
        return XmlBeans.getContextTypeLoader().newInstance(schemaType, this.xmlOptions);
    }

    public void setRepository(Repository<XmlObject> repository) {
        if (this.repository != null && !this.repository.equals(repository)) {
            String msg = "Repository cannot be reset.";
            this.logger.error((Object)msg);
            throw new RuntimeException(msg);
        }
        this.repository = repository;
        this.hasRepository = true;
    }

    public void setSchemaTypeFinder(SchemaTypeFinder schemaTypeFinder) {
        if (this.schemaTypeFinder != null && !this.schemaTypeFinder.equals(schemaTypeFinder)) {
            String msg = "Schema type finder cannot be reset.";
            this.logger.error((Object)msg);
            throw new RuntimeException(msg);
        }
        this.schemaTypeFinder = schemaTypeFinder;
    }

    public void setXmlObjectCaster(XmlObjectCaster xmlObjectCaster) {
        if (this.xmlObjectCaster != null && !this.xmlObjectCaster.equals(xmlObjectCaster)) {
            String msg = "Xml object caster cannot be reset.";
            this.logger.error((Object)msg);
            throw new RuntimeException(msg);
        }
        this.xmlObjectCaster = xmlObjectCaster;
    }

    protected final Repository<XmlObject> getRepository() {
        if (this.repository == null) {
            String msg = "Repository has not been set.";
            this.logger.error((Object)msg);
            throw new RuntimeException(msg);
        }
        return this.repository;
    }

    protected final SchemaTypeFinder getSchemaTypeFinder() {
        if (this.schemaTypeFinder == null) {
            String msg = "Schema type finder has not been set.";
            this.logger.error((Object)msg);
            throw new RuntimeException(msg);
        }
        return this.schemaTypeFinder;
    }

    protected final XmlObjectCaster getXmlObjectCaster() {
        if (this.xmlObjectCaster == null) {
            String msg = "Xml object caster has not been set.";
            this.logger.error((Object)msg);
            throw new RuntimeException(msg);
        }
        return this.xmlObjectCaster;
    }
}

