/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.dmp.store.clientrepository.file;

import java.io.File;
import java.io.IOException;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.ddialliance.ddi_3_1.xml.xmlbeans.reusable.AbstractIdentifiableType;
import org.openmetadata.ddi_3_1.util.DdiClass;
import org.openmetadata.ddi_3_1.util.URN;
import org.openmetadata.dmp.beans.DmpIDUtils;
import org.openmetadata.store.catalog.Catalog;
import org.openmetadata.store.exceptions.InvalidCriteriaException;
import org.openmetadata.store.exceptions.ObjectNotFoundException;
import org.openmetadata.store.query.Criteria;
import org.openmetadata.store.query.SearchResult;
import org.openmetadata.store.repository.file.container.SnapshotRepositoryManager;
import org.openmetadata.util.xmlbeans.XmlObjectCaster;
import org.openmetadata.xml.core.IdentifiedObjectType;

public class DmpRepositoryManager
implements SnapshotRepositoryManager<XmlObject> {
    private static final String baseContext = "ROOT_CONTEXT";
    private static final String DMP_PREFIX = "urn:dmp:";
    private static final String DEFINITION_PREFIX = "urn:dmp:definition:";
    private static final String PLAN_PREFIX = "urn:dmp:plan:";
    private static final String plans = "plans";
    private static final String definitions = "definitions";
    private static final String studies = "studies";
    private static final XmlOptions saveOptions = new XmlOptions().setSaveOuter().setSaveAggressiveNamespaces();

    public Catalog getCatalog(File workspace) {
        throw new RuntimeException("getCatalog method for file repository not implemented.");
    }

    public String[] getContextFilePaths(String contextId) {
        return new String[]{definitions, plans, studies};
    }

    public String getContainerFilePath(String id) {
        return this.idToPath(id);
    }

    public boolean contains(File container, String id) {
        this.checkId(id);
        return container.exists();
    }

    public XmlObject get(File container, String id) throws ObjectNotFoundException {
        this.checkId(id);
        try {
            return XmlObject.Factory.parse((File)container);
        }
        catch (XmlException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public SearchResult query(Criteria<?> criteria, File ... containers) throws InvalidCriteriaException {
        throw new RuntimeException("File repository query method not implmeneted.");
    }

    public String getBaseContext() {
        return baseContext;
    }

    public String getFilePath(String contextId, XmlObject container) {
        return this.idToPath(this.getId(container));
    }

    public void save(File file, XmlObject container) {
        try {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            container.save(file, saveOptions);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getId(XmlObject container) {
        if (XmlObjectCaster.canCast(AbstractIdentifiableType.class, (XmlObject)container, (boolean)false)) {
            return ((AbstractIdentifiableType)XmlObjectCaster.cast(AbstractIdentifiableType.class, (XmlObject)container)).getUrn();
        }
        if (XmlObjectCaster.canCast(IdentifiedObjectType.class, (XmlObject)container, (boolean)false)) {
            return ((IdentifiedObjectType)XmlObjectCaster.cast(IdentifiedObjectType.class, (XmlObject)container)).getId();
        }
        throw new RuntimeException("Unknown XML object (" + container.schemaType().getName().toString() + ").");
    }

    protected String idToPath(String id) {
        if (id.contains("urn:ddi")) {
            URN urn = URN.getURN((String)id);
            if (urn.getDDIClass().equals((Object)DdiClass.StudyUnit)) {
                return studies + File.separator + urn.getAgency() + urn.getId() + urn.getVersion();
            }
        } else {
            if (id.contains(PLAN_PREFIX)) {
                return plans + File.separator + id.replace(PLAN_PREFIX, "");
            }
            if (id.contains(DEFINITION_PREFIX)) {
                return definitions + File.separator + id.replace(DEFINITION_PREFIX, "");
            }
        }
        throw new RuntimeException("Cannot get path for id (" + id + ")");
    }

    protected boolean checkId(String id) {
        if (id.contains("urn:ddi")) {
            if (URN.getURN((String)id).hasParent()) {
                throw new RuntimeException("Can only get DDI maintainable objects.");
            }
        } else if (id.contains(DMP_PREFIX) && !DmpIDUtils.getContainerID((String)id).equals(id)) {
            throw new RuntimeException("Can only get DMP container objects.");
        }
        return true;
    }
}

