/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.util.xmlbeans;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;

public class XmlObjectCaster {
    private static final XmlOptions fragmentLoadOptions = new XmlOptions().setLoadReplaceDocumentElement(null);

    public static final boolean canCast(Class<? extends XmlObject> targetClass, XmlObject source, boolean allowUpCasting) {
        SchemaTypeLoader loader = XmlBeans.getContextTypeLoader();
        SchemaType targetType = XmlBeans.typeForClass(targetClass);
        if (targetType.equals(XmlObject.type)) {
            return true;
        }
        SchemaType sourceType = source.schemaType();
        if (sourceType.isDocumentType()) {
            if (targetType.isDocumentType()) {
                if (targetType.equals(sourceType)) {
                    return true;
                }
                if (targetType.isValidSubstitution(sourceType.getDocumentElementName())) {
                    return true;
                }
                if (sourceType.isValidSubstitution(targetType.getDocumentElementName())) {
                    return allowUpCasting;
                }
            } else {
                SchemaType baseContentType = loader.findElement(sourceType.getDocumentElementName()).getType();
                XmlObject sourceContent = XmlObjectCaster.getDocumentContent(source, baseContentType, false);
                SchemaType sourceContentType = sourceContent.schemaType();
                if (targetType.isAssignableFrom(sourceContentType)) {
                    return true;
                }
                if (sourceContentType.isAssignableFrom(targetType)) {
                    return allowUpCasting;
                }
            }
        } else {
            if (targetType.isDocumentType()) {
                targetType = loader.findElement(targetType.getDocumentElementName()).getType();
            }
            if (sourceType.equals(XmlBeans.NO_TYPE)) {
                return allowUpCasting;
            }
            if (targetType.isAssignableFrom(sourceType)) {
                return true;
            }
            if (sourceType.isAssignableFrom(targetType)) {
                return allowUpCasting;
            }
        }
        return false;
    }

    public static final <S extends XmlObject> S cast(Class<S> targetClass, XmlObject source) {
        SchemaType sourceType;
        SchemaTypeLoader loader = XmlBeans.getContextTypeLoader();
        SchemaType targetType = XmlBeans.typeForClass(targetClass);
        if (targetType.equals(sourceType = source.schemaType())) {
            return (S)((XmlObject)targetClass.cast(source));
        }
        if (targetType.equals(XmlObject.type)) {
            return (S)((XmlObject)targetClass.cast(source));
        }
        if (sourceType.isDocumentType()) {
            if (targetType.isDocumentType()) {
                SchemaType sourceContentType = loader.findElement(sourceType.getDocumentElementName()).getType();
                SchemaType targetContentType = loader.findElement(targetType.getDocumentElementName()).getType();
                if (targetType.equals(sourceType)) {
                    return (S)((XmlObject)targetClass.cast(source));
                }
                if (targetType.isValidSubstitution(sourceType.getDocumentElementName())) {
                    XmlObject request = (XmlObject)targetClass.cast(loader.newInstance(targetType, null));
                    XmlObjectCaster.getDocumentContent(request, targetContentType, true).set(XmlObjectCaster.getDocumentContent(source, sourceContentType, false));
                    return (S)request;
                }
                if (sourceType.isValidSubstitution(targetType.getDocumentElementName())) {
                    XmlObject sourceContent = XmlObjectCaster.getDocumentContent(source, sourceContentType, false).substitute(targetType.getDocumentElementName(), targetContentType);
                    XmlObject request = (XmlObject)targetClass.cast(XmlBeans.getContextTypeLoader().newInstance(targetType, null));
                    XmlObjectCaster.getDocumentContent(request, targetContentType, true).set(sourceContent);
                    return (S)request;
                }
            } else {
                SchemaType baseContentType = loader.findElement(sourceType.getDocumentElementName()).getType();
                XmlObject sourceContent = XmlObjectCaster.getDocumentContent(source, baseContentType, false);
                SchemaType sourceContentType = sourceContent.schemaType();
                if (targetType.isAssignableFrom(sourceContentType) && !sourceType.equals(XmlBeans.NO_TYPE)) {
                    return (S)((XmlObject)targetClass.cast(sourceContent));
                }
                if (sourceContentType.isAssignableFrom(targetType)) {
                    return (S)((XmlObject)targetClass.cast(sourceContent.changeType(targetType)));
                }
            }
        } else if (targetType.isDocumentType()) {
            SchemaType requestContentType = loader.findElement(targetType.getDocumentElementName()).getType();
            if (requestContentType.isAssignableFrom(sourceType) || sourceType.equals(XmlBeans.NO_TYPE)) {
                XmlObject target = (XmlObject)targetClass.cast(loader.newInstance(targetType, null));
                XmlObjectCaster.getDocumentContent(target, requestContentType, true).set((XmlObject)XmlObjectCaster.cast(requestContentType.getJavaClass(), source));
                return (S)target;
            }
            if (sourceType.isAssignableFrom(requestContentType)) {
                XmlObject target = (XmlObject)targetClass.cast(loader.newInstance(targetType, null));
                XmlObjectCaster.getDocumentContent(target, requestContentType, true).set(source.changeType(requestContentType));
                return (S)target;
            }
        } else {
            if (sourceType.equals(XmlBeans.NO_TYPE)) {
                try {
                    return (S)((XmlObject)targetClass.cast(loader.parse(source.newXMLStreamReader(), targetType, fragmentLoadOptions)));
                }
                catch (XmlException e) {
                    throw new RuntimeException(e);
                }
            }
            if (targetType.isAssignableFrom(sourceType)) {
                return (S)((XmlObject)targetClass.cast(source));
            }
            if (sourceType.isAssignableFrom(targetType)) {
                return (S)((XmlObject)targetClass.cast(source.changeType(targetType)));
            }
        }
        throw new RuntimeException("Requested document type is not valid for serialization type.");
    }

    private static XmlObject getDocumentContent(XmlObject document, SchemaType contentType, boolean isNew) {
        String nameStart = isNew ? "addNew" : "get";
        Method[] methodArray = document.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.getName().startsWith(nameStart) && m.getReturnType().equals(contentType.getJavaClass())) {
                try {
                    XmlObject xo = (XmlObject)m.invoke((Object)document, new Object[0]);
                    if (xo == null && !isNew) {
                        return XmlObjectCaster.getDocumentContent(document, contentType, true);
                    }
                    return xo;
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        throw new RuntimeException("Could not find document content getter.");
    }
}

