/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.util.xmlbeans;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlRuntimeException;
import org.openmetadata.util.xmlbeans.ValidatorExpression;

public class Validator {
    Logger logger = Logger.getLogger(this.getClass().getName());
    XmlObject xmlObject;
    ArrayList<ValidatorExpression> expressions = new ArrayList();
    String separator = "\\|";

    public Validator() {
    }

    public Validator(XmlObject xmlObject) {
        this.setXmlObject(xmlObject);
    }

    public void addExpressions(ValidatorExpression ... expressions) {
        this.expressions.addAll(Arrays.asList(expressions));
    }

    public void addExpressions(String ... strExpressions) {
        this.addExpressions(this.separator, strExpressions);
    }

    public void addExpression(String strExpression) {
        this.addExpression(this.separator, strExpression);
    }

    public void addExpressions(String separator, String ... strExpressions) {
        String[] stringArray = strExpressions;
        int n = strExpressions.length;
        int n2 = 0;
        while (n2 < n) {
            String strExpression = stringArray[n2];
            this.addExpression(separator, strExpression);
            ++n2;
        }
    }

    public void addExpression(String separator, String strExpression) {
        String[] tokens = strExpression.split(separator, 4);
        if (tokens.length >= 3 && tokens.length <= 4) {
            ValidatorExpression.TYPE type = ValidatorExpression.TYPE.valueOf(tokens[0]);
            if (type != null) {
                ValidatorExpression expression = null;
                if (type == ValidatorExpression.TYPE.NS_PREFIX) {
                    expression = new ValidatorExpression(type, tokens[1], tokens[2]);
                } else {
                    ValidatorExpression.LOG_LEVEL level = ValidatorExpression.LOG_LEVEL.valueOf(tokens[1]);
                    if (level != null) {
                        expression = new ValidatorExpression(type, level, tokens[2]);
                    }
                }
                if (tokens.length == 4) {
                    expression.setDescription(tokens[3]);
                }
                if (expression != null) {
                    this.addExpression(expression);
                }
            }
        } else {
            this.logger.error("Invalid #tokens (" + tokens.length + ") in expression " + strExpression);
        }
    }

    public void addExpression(ValidatorExpression expression) {
        this.expressions.add(expression);
    }

    public int validate() {
        int nErrors = 0;
        String nsPrefixes = "";
        for (ValidatorExpression expression : this.expressions) {
            if (expression.getType() != ValidatorExpression.TYPE.NS_PREFIX) continue;
            nsPrefixes = String.valueOf(nsPrefixes) + "declare namespace " + expression.getPrefix() + "='" + expression.getValue() + "';";
        }
        if (this.xmlObject != null) {
            for (ValidatorExpression expression : this.expressions) {
                XmlCursor cursor = this.xmlObject.newCursor();
                String message = null;
                boolean success = false;
                switch (expression.getType()) {
                    case XPATH: {
                        String xpath = String.valueOf(nsPrefixes) + expression.getValue();
                        message = expression.getDescription();
                        message = message != null ? String.valueOf(message) + ". XPATH:" + expression.getValue() : expression.getValue();
                        try {
                            cursor.selectPath(xpath);
                            if (cursor.getSelectionCount() == 1) {
                                cursor.toNextSelection();
                                success = new Boolean(cursor.getTextValue());
                                break;
                            }
                            message = "XPath returned nothing or more than one object.";
                        }
                        catch (RuntimeException e) {
                            this.logger.error(e.getMessage());
                        }
                        break;
                    }
                    case XQUERY: {
                        String xquery = String.valueOf(nsPrefixes) + expression.getValue();
                        message = expression.getDescription();
                        message = message != null ? String.valueOf(message) + ". XQUERY: " + expression.getValue() : expression.getValue();
                        try {
                            XmlCursor result = cursor.execQuery(xquery);
                            if (result == null) break;
                            success = new Boolean(result.getTextValue());
                        }
                        catch (XmlRuntimeException e) {
                            this.logger.error(e.getMessage());
                        }
                        break;
                    }
                }
                if (message != null) {
                    if (success) {
                        this.logger.info("PASSED: " + message);
                    } else {
                        message = "FAILED: " + message;
                        switch (expression.getLevel()) {
                            case ERROR: {
                                this.logger.error(message);
                                break;
                            }
                            case WARNING: {
                                this.logger.warn(message);
                                break;
                            }
                            case INFO: {
                                this.logger.info(message);
                            }
                        }
                    }
                }
                cursor.dispose();
            }
        } else {
            ++nErrors;
            this.logger.error("XmlObject not set");
        }
        return nErrors;
    }

    public XmlObject getXmlObject() {
        return this.xmlObject;
    }

    public void setXmlObject(XmlObject xmlObject) {
        this.xmlObject = xmlObject;
    }

    public ArrayList<ValidatorExpression> getExpressions() {
        return this.expressions;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }
}

