/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.util.idgenerator;

import java.util.HashSet;
import java.util.Random;
import java.util.UUID;
import org.openmetadata.util.IdGeneratorException;
import org.openmetadata.util.idgenerator.IdGenerator;

public class AlphaNumIdGenerator
implements IdGenerator {
    int length = 16;
    HashSet<String> reserved = null;

    public AlphaNumIdGenerator() {
    }

    public AlphaNumIdGenerator(int length) {
        this.setLength(length);
    }

    public AlphaNumIdGenerator(int length, HashSet<String> reserved) {
        this.setLength(length);
        this.setReserved(reserved);
    }

    @Override
    public String generateId(Object object) throws IdGeneratorException {
        return AlphaNumIdGenerator.generateUniqueId(this.length, this.reserved);
    }

    public static String generateUniqueId(int length, HashSet<String> reserved) throws IdGeneratorException {
        String charsStr = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
        char[] chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789".toCharArray();
        Random generator = new Random(System.currentTimeMillis() + (long)AlphaNumIdGenerator.class.hashCode() + UUID.randomUUID().getLeastSignificantBits());
        String id = "";
        boolean isUnique = false;
        int iter = 0;
        while (!isUnique) {
            id = String.valueOf(id) + chars[generator.nextInt(52)];
            int i = 1;
            while (i < length) {
                id = String.valueOf(id) + chars[generator.nextInt(62)];
                ++i;
            }
            if (reserved == null) {
                isUnique = true;
                continue;
            }
            if (!reserved.contains(id)) {
                isUnique = true;
                reserved.add(id);
                continue;
            }
            id = "";
            if (++iter < 50) continue;
            throw new IdGeneratorException("Too many iterations in id generator (" + iter + "). Key length is " + length + ", reserved list contains " + reserved.size() + " keys.");
        }
        return id;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public HashSet<String> getReserved() {
        return this.reserved;
    }

    public void setReserved(HashSet<String> reserved) {
        this.reserved = reserved;
    }
}

