/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.ddi_2_5.util.idgenerator;

import java.util.HashSet;
import org.ddialliance.ddi_2_5.xml.xmlbeans.CodeBookType;
import org.openmetadata.util.IdGeneratorException;
import org.openmetadata.util.idgenerator.AlphaNumIdGenerator;
import org.openmetadata.util.idgenerator.IdGenerator;

public class Ddi25AlphaNumIdGenerator
implements IdGenerator {
    int globalLength = 16;
    int localLength = 8;
    boolean autoReserve = true;
    HashSet<String> reservedGlobalIds = null;
    HashSet<String> reservedLocalIds = null;

    @Override
    public String generateId(Object object) throws IdGeneratorException {
        String id = null;
        if (object instanceof CodeBookType) {
            id = AlphaNumIdGenerator.generateUniqueId(this.globalLength, this.reservedGlobalIds);
            if (this.autoReserve) {
                this.addReservedGlobalId(id);
            }
        } else {
            id = AlphaNumIdGenerator.generateUniqueId(this.localLength, this.reservedLocalIds);
            if (this.autoReserve) {
                this.addReservedLocalId(id);
            }
        }
        return id;
    }

    public void addReservedGlobalId(String id) {
        if (this.reservedGlobalIds == null) {
            this.reservedGlobalIds = new HashSet();
        }
        this.reservedGlobalIds.add(id);
    }

    public void addReservedLocalId(String id) {
        if (this.reservedLocalIds == null) {
            this.reservedLocalIds = new HashSet();
        }
        this.reservedLocalIds.add(id);
    }

    public int getGlobalLength() {
        return this.globalLength;
    }

    public void setGlobalLength(int globalLength) {
        this.globalLength = globalLength;
    }

    public int getLocalLength() {
        return this.localLength;
    }

    public void setLocalLength(int localLength) {
        this.localLength = localLength;
    }

    public boolean isAutoReserve() {
        return this.autoReserve;
    }

    public void setAutoReserve(boolean autoReserve) {
        this.autoReserve = autoReserve;
    }

    public HashSet<String> getReservedGlobalIds() {
        return this.reservedGlobalIds;
    }

    public void setReservedGlobalIds(HashSet<String> reservedGlobalIds) {
        this.reservedGlobalIds = reservedGlobalIds;
    }

    public HashSet<String> getReservedLocalIds() {
        return this.reservedLocalIds;
    }

    public void setReservedLocalIds(HashSet<String> reservedLocalIds) {
        this.reservedLocalIds = reservedLocalIds;
    }
}

