/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.ddi_2_5.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlCursor;
import org.ddialliance.ddi_2_5.xml.xmlbeans.CodeBookDocument;
import org.ddialliance.ddi_2_5.xml.xmlbeans.CodeBookType;
import org.ddialliance.ddi_2_5.xml.xmlbeans.FileDscrType;
import org.ddialliance.ddi_2_5.xml.xmlbeans.FileTxtType;
import org.ddialliance.ddi_2_5.xml.xmlbeans.SimpleTextType;

public class CodebookFileDscrFinder {
    private Map<Integer, String> fdMap = new LinkedHashMap<Integer, String>();
    private Map<String, String> idToFileMap = new LinkedHashMap<String, String>();
    private Log log = LogFactory.getLog(this.getClass());

    public CodebookFileDscrFinder(File codebookFile) {
        try {
            this.addNameSpace(codebookFile);
        }
        catch (IOException e) {
            this.log.error("Could not create log file with proper namespace", e);
        }
    }

    private void addNameSpace(File file) throws IOException {
        String tDir = System.getProperty("java.io.tmpdir");
        File temp = new File(String.valueOf(tDir) + "/" + file.getName());
        FileReader fr = new FileReader(file);
        BufferedReader br = new BufferedReader(fr);
        BufferedWriter output = new BufferedWriter(new FileWriter(temp));
        String part = "";
        boolean needsAdjustment = true;
        while ((part = br.readLine()) != null) {
            String docType = "<!DOCTYPE[^>]*>";
            if (part.contains("<!DOCTYPE")) {
                if (part.matches(docType)) {
                    part = part.replaceFirst(docType, "");
                } else if ((part = String.valueOf(part) + " " + br.readLine()).matches(docType)) {
                    part = part.replaceFirst(docType, "");
                }
            }
            if (part.contains("codeBook") && needsAdjustment) {
                if (!part.contains("http://www.icpsr.umich.edu/DDI")) {
                    part = part.replaceFirst("codeBook", "codeBook xmlns=\"http://www.icpsr.umich.edu/DDI\"  ");
                }
                if (part.contains("http://www.icpsr.umich.edu/DDI")) {
                    part = part.replaceFirst("http://www.icpsr.umich.edu/DDI", "ddi:codebook:2_5");
                }
                if (part.contains("version=\"1.2.2\"")) {
                    part = part.replaceFirst("codeBook version=\"1.2.2\"", "codeBook version=\"2.5\" ");
                }
                if (part.contains("version=\"2.0\"")) {
                    part = part.replaceFirst("codeBook version=\"2.0\"", "codeBook version=\"2.5\" ");
                }
                if (part.contains("version=\"2.1\"")) {
                    part = part.replaceFirst("codeBook version=\"2.1\"", "codeBook version=\"2.5\" ");
                }
                needsAdjustment = false;
                System.out.println(part);
            } else if (part.startsWith("<?")) {
                System.out.println(part);
            }
            output.write(part);
        }
        ((Writer)output).flush();
        ((Writer)output).close();
        System.out.println(fr.getEncoding());
        fr.close();
        this.initializeMap(temp);
    }

    public Map<String, String> getAvailableFileDscrIds() {
        return this.idToFileMap;
    }

    public String getId(Integer index) {
        if (this.fdMap.get(index) == null) {
            throw new RuntimeException("No file description could be found at index: " + index + ". Please ensure" + " that the correct index was specified.");
        }
        return this.fdMap.get(index);
    }

    public Integer getIndex(String id) {
        for (Integer key : this.fdMap.keySet()) {
            String value = this.fdMap.get(key);
            if (!id.equalsIgnoreCase(value)) continue;
            return key;
        }
        throw new RuntimeException("No filedscr found with ID: " + id);
    }

    private void initializeMap(File cbf) {
        try {
            CodeBookDocument cbd = CodeBookDocument.Factory.parse(cbf);
            CodeBookType cb = cbd.getCodeBook();
            int i = 0;
            while (i < cb.getFileDscrList().size()) {
                FileTxtType fileTxt;
                FileDscrType fd = cb.getFileDscrArray(i);
                this.fdMap.put(i + 1, fd.getID());
                String fileName = "No file name";
                if (fd.getFileTxtList().size() > 0 && (fileTxt = fd.getFileTxtArray(0)).getFileNameList().size() > 0) {
                    SimpleTextType fn = fileTxt.getFileNameArray(0);
                    XmlCursor fnCurs = fn.newCursor();
                    fileName = fnCurs.getTextValue().trim();
                    fnCurs.dispose();
                }
                this.idToFileMap.put(fd.getID(), fileName);
                ++i;
            }
            System.gc();
        }
        catch (Exception e) {
            this.log.error("Could not initialize codebook", e);
        }
    }
}

