/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.dataset;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.math.NumberUtils;
import org.openmetadata.dataset.Code;
import org.openmetadata.dataset.DataFile;
import org.openmetadata.dataset.SummaryStatisticsOptions;
import org.openmetadata.dataset.Variable;

public class SummaryStatistics {
    String id;
    double invalid = 0.0;
    double max = Double.NEGATIVE_INFINITY;
    double min = Double.POSITIVE_INFINITY;
    double median = 0.0;
    double meanValTotal = 0.0;
    double mean = 0.0;
    double stdDeviation = 0.0;
    double variance = 0.0;
    double totalDev = 0.0;
    double valid = 0.0;
    double weight = 1.0;
    boolean secondRun = false;
    boolean isInt = false;
    boolean checkInt = true;
    Object mode;
    ArrayList<Double> values = new ArrayList();
    ArrayList<Double> devValueList = new ArrayList();
    ArrayList<Object> uniqueValues = new ArrayList();
    SummaryStatisticsOptions options;
    LinkedHashMap<Object, Double> frequencies = new LinkedHashMap();
    LinkedHashMap<Object, Double> devValueMap = new LinkedHashMap();
    LinkedHashMap<Integer, Integer> decimals = new LinkedHashMap();

    public SummaryStatistics(SummaryStatisticsOptions options, Variable var, DataFile dataFile) {
        this.options = options;
        this.setId(options.getId());
        this.initializeFrequencies(var, dataFile);
    }

    private void initializeFrequencies(Variable var, DataFile dataFile) {
        if (var.getCodeListId() != null && !var.getCodeListId().isEmpty()) {
            for (Code code : dataFile.getCodeList(var.getCodeListId()).getCodeList().values()) {
                Object codeValue = code.getCode();
                if (var.getDataType() == Variable.DATA_TYPE.NUMERIC && NumberUtils.isNumber(codeValue.toString())) {
                    codeValue = Double.parseDouble(codeValue.toString());
                }
                this.frequencies.put(codeValue, 0.0);
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double max) {
        this.max = max;
    }

    public double getMin() {
        return this.min;
    }

    public void setMin(double min) {
        this.min = min;
    }

    public double getMean() {
        return this.mean;
    }

    public void setMean(double mean) {
        this.mean = mean;
    }

    public double getStdDeviation() {
        return this.stdDeviation;
    }

    public void setStdDeviation(double stdDeviation) {
        this.stdDeviation = stdDeviation;
    }

    public double getMedian() {
        return this.median;
    }

    public void setMedian(double median) {
        this.median = median;
    }

    public Object getMode() {
        return this.mode;
    }

    public void setMode(Object mode) {
        this.mode = mode;
    }

    public double getValid() {
        return this.valid;
    }

    public void setValid(double valid) {
        this.valid = valid;
    }

    public double getInvalid() {
        return this.invalid;
    }

    public void setInvalid(double invalid) {
        this.invalid = invalid;
    }

    public LinkedHashMap<Object, Double> getFrequencies() {
        return this.frequencies;
    }

    public void setFrequencies(LinkedHashMap<Object, Double> frequencies) {
        this.frequencies = frequencies;
    }

    public SummaryStatisticsOptions getOptions() {
        return this.options;
    }

    public String toString() {
        return String.valueOf(this.getMax()) + "|" + this.getMin() + "|" + this.getMean() + "|" + this.getMean() + "|" + this.getMode() + "|" + this.getValid() + "|" + this.getInvalid() + "|" + this.getFrequencies() + "|";
    }

    public ArrayList<Double> getValues() {
        return this.values;
    }

    public void setValues(ArrayList<Double> values) {
        this.values = values;
    }

    public double getVariance() {
        return this.variance;
    }

    public void setVariance(double variance) {
        this.variance = variance;
    }

    public boolean isSecondRun() {
        return this.secondRun;
    }

    public void setSecondRun(boolean secondRun) {
        this.secondRun = secondRun;
    }

    public double getMeanValTotal() {
        return this.meanValTotal;
    }

    public void setMeanValTotal(double meanValTotal) {
        this.meanValTotal = meanValTotal;
    }

    public double getTotalDev() {
        return this.totalDev;
    }

    public void setTotalDev(double totalDev) {
        this.totalDev = totalDev;
    }

    public ArrayList<Double> getDevValueList() {
        return this.devValueList;
    }

    public void addToDevValueList(Double value) {
        this.devValueList.add(value);
    }

    public HashMap<Object, Double> getDevValueMap() {
        return this.devValueMap;
    }

    public double getWeight() {
        return this.weight;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public boolean isInt() {
        return this.isInt;
    }

    public void setIsInt(boolean isInt) {
        this.isInt = isInt;
    }

    public boolean checkInt() {
        return this.checkInt;
    }

    public void setCheckInt(boolean checkInt) {
        this.checkInt = checkInt;
    }

    public HashMap<Integer, Integer> getDecimalsMap() {
        return this.decimals;
    }

    public ArrayList<Object> getUniqueValues() {
        return this.uniqueValues;
    }
}

