/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.cache.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.openmetadata.cache.LockingCache;
import org.openmetadata.cache.impl.SoftCache;

public abstract class SoftLockingCache<T>
extends SoftCache<T>
implements LockingCache<T> {
    private HashMap<T, Set<Object>> captureMap = new HashMap();

    @Override
    public void remove(T object) {
        this.logger.debug("Removing object");
        if (!this.captureMap.containsKey(object)) {
            super.remove(object);
        }
        this.logger.debug("Object cannot be removed");
    }

    @Override
    public void capture(T object, Object requester) {
        Set<Object> requesterSet;
        this.logger.debug("Capturing object");
        String id = this.extractId(object);
        if (!this.hash.containsKey(id) || this.hash.get(id) == null || ((SoftCache.SoftIdentifiableObjectReference)this.hash.get(id)).get() == null) {
            this.logger.warn("Unexpected forced capture of [" + id + "]");
            this.add(object);
        }
        if ((requesterSet = this.captureMap.get(object)) == null) {
            requesterSet = new HashSet<Object>();
        }
        requesterSet.add(requester);
        this.captureMap.put(object, requesterSet);
    }

    @Override
    public void release(T object, Object requester) {
        this.logger.debug("Releasing object");
        Set<Object> requesterSet = this.captureMap.get(object);
        if (requesterSet == null) {
            this.captureMap.remove(object);
        } else {
            requesterSet.remove(requester);
            if (requesterSet.isEmpty()) {
                this.captureMap.remove(object);
            }
        }
    }
}

