package org.openmetadata.beans.ddi.lifecycle.reusable.impl;

import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.ProprietaryPropertyBean;
import org.apache.commons.lang3.StringUtils;
import org.openmetadata.beans.notification.ChangeListener;

public class ProprietaryPropertyBeanImpl extends UnsettableDdiBeanImpl
		implements ProprietaryPropertyBean {

	private String name;
	private String codeListID;
	private String codeListName;
	private String codeListAgencyName;
	private String codeListVersionID;
	private String otherValue;
	private String codeListUrn;
	private String codeListSchemeUrn;

	public ProprietaryPropertyBeanImpl(DdiBeanFactory beanFactory,
			ChangeListener changeListener) {
		super(beanFactory, changeListener);
	}

	public void setName(String name) {
		this.name = name;
	}

	@Override
	public String getName() {
		return StringUtils.defaultString(this.name);
	}

	@Override
	public boolean isSetCodeListID() {
		return codeListID != null && codeListID.isEmpty() == false;
	}

	@Override
	public String getCodeListID() {
		return StringUtils.defaultString(codeListID);
	}

	@Override
	public void setCodeListID(String value) {
		codeListID = value;
		this.ddiBeanChanged();
	}

	@Override
	public boolean isSetCodeListName() {
		return codeListName != null;
	}

	@Override
	public String getCodeListName() {
		return StringUtils.defaultString(codeListName);
	}

	@Override
	public void setCodeListName(String value) {
		codeListName = value;
		this.ddiBeanChanged();
	}

	@Override
	public boolean isSetCodeListAgencyName() {
		return codeListAgencyName != null;
	}

	@Override
	public String getCodeListAgencyName() {
		return StringUtils.defaultString(codeListAgencyName);
	}

	@Override
	public void setCodeListAgencyName(String value) {
		codeListAgencyName = value;
		this.ddiBeanChanged();
	}

	@Override
	public boolean isSetCodeListVersionID() {
		return codeListVersionID != null;
	}

	@Override
	public String getCodeListVersionID() {
		return StringUtils.defaultString(codeListVersionID);
	}

	@Override
	public void setCodeListVersionID(String value) {
		codeListVersionID = value;
		this.ddiBeanChanged();
	}

	@Override
	public boolean isSetOtherValue() {
		return otherValue != null;
	}

	@Override
	public String getOtherValue() {
		return StringUtils.defaultString(otherValue);
	}

	@Override
	public void setOtherValue(String value) {
		otherValue = value;
		this.ddiBeanChanged();
	}

	@Override
	public boolean isSetCodeListUrn() {
		return codeListUrn != null;
	}

	@Override
	public String getCodeListUrn() {
		return StringUtils.defaultString(codeListUrn);
	}

	@Override
	public void setCodeListUrn(String value) {
		codeListUrn = value;
		this.ddiBeanChanged();
	}

	@Override
	public boolean isSetCodeListSchemeUrn() {
		return codeListSchemeUrn != null;
	}

	@Override
	public String getCodeListSchemeUrn() {
		return StringUtils.defaultString(codeListSchemeUrn);
	}

	@Override
	public void setCodeListSchemeUrn(String value) {
		codeListSchemeUrn = value;
		this.ddiBeanChanged();
	}
	
	@Override
	protected boolean internalIsSet() {
		return !StringUtils.isEmpty(name) || 
				!StringUtils.isEmpty(codeListID) ||
				!StringUtils.isEmpty(codeListName);
	}
}
