package org.openmetadata.beans.ddi.lifecycle.reusable.impl;

import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.CodeSchemeBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.CodeRepresentationBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.ddi.util.exceptions.URNFormatException;
import org.openmetadata.beans.exceptions.ResolverException;
import org.openmetadata.beans.notification.ChangeListener;

public abstract class CodeRepresentationBeanImpl extends RepresentationBeanImpl
		implements CodeRepresentationBean {

	private final ReferenceBeanImpl<CodeSchemeBean> codeSchemeReference;

	public CodeRepresentationBeanImpl(IdentifiableBean referrer,
			DdiBeanFactory factory, ChangeListener listener) {
		super(factory, listener);
		codeSchemeReference = new ReferenceBeanImpl<CodeSchemeBean>(
				CodeSchemeBean.class, factory, this);
	}

	public void initSetCodeSchemeUrn(String urn) throws URNFormatException {
		codeSchemeReference.setReferenceUrn(urn);
	}

	public ReferenceBeanImpl<CodeSchemeBean> getCodeSchemeReference() {
		return codeSchemeReference;
	}

	@Override
	public boolean isSetCodeScheme() {
		return codeSchemeReference.isSet();
	}

	@Override
	public void setCodeScheme(CodeSchemeBean codeScheme)
		 {
		this.codeSchemeReference.setReferenceTo(codeScheme);
	}

	@Override
	public CodeSchemeBean getCodeScheme() {
		try {
			return this.codeSchemeReference.getReferredObject();
		} catch (ResolverException e) {
			return null;
		}
	}
	
	@Override
	public boolean internalIsSet() {
		return codeSchemeReference.isSet();
	}
}
