package org.openmetadata.beans.ddi.lifecycle.reusable.impl;

import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.SchemeBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.SchemeItemBean;
import org.openmetadata.ddi_3_1.util.URN;
import org.openmetadata.beans.exceptions.ResolverException;
import org.openmetadata.beans.impl.MutableBeanInitializer;

public abstract class AbstractSchemeItemBean<B extends SchemeBean> extends
		AbstractVersionableBeanImpl implements SchemeItemBean<B> {

	private final String parentUrn;

	public AbstractSchemeItemBean(boolean newInstance, URN urn,
			MutableBeanInitializer beanInitializer,
			DdiBeanFactory beanFactory) {
		super(newInstance, urn, beanInitializer, beanFactory);

		parentUrn = urn.getParent().toString();
	}

	@SuppressWarnings("unchecked")
	@Override
	public B getParentScheme() {
		try {
			return (B) this.getResolver().resolve(SchemeBean.class, parentUrn);
		} catch (ResolverException e) {
			e.printStackTrace();
			return null;
		}
	}

	@Override
	public String getParentSchemeUrn() {
		return parentUrn;
	}
}
