package org.openmetadata.beans.ddi.lifecycle.physicaldataproduct.impl;

import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.physicaldataproduct.BaseRecordLayoutBean;
import org.openmetadata.beans.ddi.lifecycle.physicaldataproduct.PhysicalStructureBean;
import org.openmetadata.beans.ddi.lifecycle.physicaldataproduct.RecordLayoutSchemeBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.AbstractSchemeItemBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.ReferenceBeanImpl;
import org.openmetadata.ddi.util.exceptions.URNFormatException;
import org.openmetadata.ddi_3_1.util.URN;
import org.apache.commons.lang3.StringUtils;
import org.openmetadata.beans.exceptions.ResolverException;
import org.openmetadata.beans.impl.MutableBeanInitializer;

public abstract class AbstractBaseRecordLayoutBeanImpl extends
		AbstractSchemeItemBean<RecordLayoutSchemeBean> implements
		BaseRecordLayoutBean {

	private final ReferenceBeanImpl<PhysicalStructureBean> phyStructRef;

	private String physicalRecordSegmentUsed = "";

	public AbstractBaseRecordLayoutBeanImpl(Boolean isNewInstance, URN urn,
			MutableBeanInitializer beanInitializer,
			DdiBeanFactory factory) {
		super(isNewInstance, urn, beanInitializer, factory);
		phyStructRef = new ReferenceBeanImpl<PhysicalStructureBean>(
				PhysicalStructureBean.class, factory, this);
	}

	public void initSetPhysicalStructureUrn(String urn)
			throws URNFormatException {
		phyStructRef.setReferenceUrn(urn);
	}

	@Override
	public void setPhysicalStructure(PhysicalStructureBean psBean)
			 {
		phyStructRef.setReferenceTo(psBean);
	}

	@Override
	public PhysicalStructureBean getPhysicalStructure() {
		try {
			return phyStructRef.getReferredObject();
		} catch (ResolverException e) {
			return null;
		}
	}

	@Override
	public String getPhysicalStructureUrn() {
		return phyStructRef.getUrn();
	}

	@Override
	public String getPhysicalRecrodSegmentUsed() {
		return StringUtils.defaultString(this.physicalRecordSegmentUsed);
	}

	@Override
	public void setPhysicalRecordSegmentUsed(String value) {
		this.physicalRecordSegmentUsed = value;
	}
}
