package org.openmetadata.beans.ddi.lifecycle.archive.impl;

import org.openmetadata.ddi_3_1.util.DdiClass;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.ReferenceSetImpl;
import org.openmetadata.beans.ddi.lifecycle.archive.ArchiveBean;
import org.openmetadata.beans.ddi.lifecycle.archive.ArchiveSpecificBean;
import org.openmetadata.beans.ddi.lifecycle.archive.OrganizationSchemeBean;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.AbstractMaintainableBeanImpl;
import org.openmetadata.beans.impl.MutableBeanInitializer;

import org.openmetadata.ddi_3_1.util.URN;

public class ArchiveBeanImpl extends AbstractMaintainableBeanImpl implements
		ArchiveBean {

	protected ReferenceSetImpl<OrganizationSchemeBean> organizationSchemes;
	protected ArchiveSpecificBeanImpl archiveSpecific;
	
	public ArchiveBeanImpl(Boolean isNewInstance, URN urn,
			MutableBeanInitializer beanInitializer,
			DdiBeanFactory beanFactory) {
		super(isNewInstance, urn, beanInitializer, beanFactory);
		organizationSchemes = new ReferenceSetImpl<OrganizationSchemeBean>(
				OrganizationSchemeBean.class, beanInitializer, beanFactory, this);
		
		archiveSpecific = new ArchiveSpecificBeanImpl(this, beanFactory, this);
	}

	public void initSetOrganizationSchemes(String[] orgSchemeUrns) {
		organizationSchemes.initReferenceUrns(orgSchemeUrns);
	}
	
	@Override
	public ArchiveSpecificBean getArchiveSpecific() {
		return archiveSpecific;
	}

	@Override
	public ReferenceSetImpl<OrganizationSchemeBean> getOrganizationSchemeList() {
		return organizationSchemes;
	}

	@Override
	public void doChangeReference(IdentifiableBean toDerefer,
			IdentifiableBean toRefer) {
		// TODO Auto-generated method stub
	}

	@Override
	protected void doRemoveReference(IdentifiableBean toRemove) {
		// TODO Auto-generated method stub
	}

	@Override
	public DdiClass getDdiClass() {
		return DdiClass.Archive;
	}

	@Override
	public Class<? extends IdentifiableBean> getBeanType() {
		return ArchiveBean.class;
	}

}