/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.beans.ddi.lifecycle.adt;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.exceptions.ResolverException;
import org.openmetadata.beans.reference.Resolver;

public class ResolvingSet<B extends IdentifiableBean>
implements Iterable<B> {
    private Set<String> urnSet = new HashSet<String>();
    private Resolver resolver;
    private Class<B> beanClass;

    public ResolvingSet(Set<String> urnSet, Class<B> beanClass, Resolver resolver) {
        this.urnSet.addAll(urnSet);
        this.resolver = resolver;
    }

    public int size() {
        return this.urnSet.size();
    }

    public String[] getIDs() {
        return this.urnSet.toArray(new String[0]);
    }

    public B[] toArray() {
        ArrayList<IdentifiableBean> list = new ArrayList<IdentifiableBean>();
        for (IdentifiableBean bean : this) {
            list.add(bean);
        }
        IdentifiableBean[] typeArr = (IdentifiableBean[])Array.newInstance(this.beanClass, 0);
        return list.toArray(typeArr);
    }

    @Override
    public Iterator<B> iterator() {
        ArrayList<IdentifiableBean> list = new ArrayList<IdentifiableBean>();
        for (String urn : this.urnSet) {
            try {
                IdentifiableBean bean = (IdentifiableBean)this.resolver.resolve(this.beanClass, urn);
                list.add(bean);
            }
            catch (ResolverException e) {
                e.printStackTrace();
                return new ArrayList().iterator();
            }
        }
        return list.iterator();
    }
}

