/*
 * Decompiled with CFR 0.152.
 */
package us.mtna.c2metadata.xml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlObject;
import org.c2Metadata.eml211.AttributeType;
import org.c2Metadata.eml211.DataTableDerivationType;
import org.c2Metadata.eml211.DataTableSDTLCommandType;
import org.c2Metadata.eml211.DataTableType;
import org.c2Metadata.eml211.DerivationType;
import org.c2Metadata.eml211.DerivedAttributesType;
import org.c2Metadata.eml211.FileDerivationCasesType;
import org.c2Metadata.eml211.SDTLCommandType;
import org.ecoinformatics.eml_2_1_1.attribute.xml.xmlbeans.AttributeListType;
import org.ecoinformatics.eml_2_1_1.attribute.xml.xmlbeans.AttributeType;
import org.ecoinformatics.eml_2_1_1.attribute.xml.xmlbeans.NonNumericDomainType;
import org.ecoinformatics.eml_2_1_1.dataset.xml.xmlbeans.DatasetType;
import org.ecoinformatics.eml_2_1_1.datatable.xml.xmlbeans.DataTableType;
import org.ecoinformatics.eml_2_1_1.party.xml.xmlbeans.Person;
import org.ecoinformatics.eml_2_1_1.party.xml.xmlbeans.ResponsibleParty;
import org.ecoinformatics.eml_2_1_1.resource.xml.xmlbeans.I18NNonEmptyStringType;
import org.ecoinformatics.eml_2_1_1.xml.xmlbeans.EmlDocument;
import org.openmetadata.util.xmlbeans.XhtmlUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.mtna.c2metadata.xml.XmlUpdater;
import us.mtna.pojo.Classification;
import us.mtna.pojo.Code;
import us.mtna.pojo.DataSet;
import us.mtna.pojo.FileTransform;
import us.mtna.pojo.Transform;
import us.mtna.pojo.TransformCommand;
import us.mtna.pojo.Variable;
import us.mtna.updater.Author;
import us.mtna.updater.DatasetMetadata;
import us.mtna.updater.EmlAuthor;

public class EmlUpdater
implements XmlUpdater {
    private DatasetMetadata datasetMetadata;
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private Map<String, Map<String, AttributeType>> originalAttMap = new HashMap<String, Map<String, AttributeType>>();

    @Override
    public XmlObject updateXml(XmlObject original, DataSet ... newDataSets) {
        if (this.datasetMetadata == null) {
            this.datasetMetadata = new DatasetMetadata();
        }
        EmlDocument originalDocument = (EmlDocument)original.changeType(EmlDocument.type);
        EmlDocument updatedDocument = this.initializeDocument();
        this.copyOriginalEml(originalDocument.getEml(), updatedDocument.getEml());
        updatedDocument.getEml().setPackageId(this.datasetMetadata.getPopulatedId());
        updatedDocument.getEml().setSystem(Arrays.asList("C2M Metadata Generator"));
        int fileCount = this.originalAttMap.keySet().size();
        DataSet[] dataSetArray = newDataSets;
        int n = newDataSets.length;
        int n2 = 0;
        while (n2 < n) {
            String fileId;
            DataSet dataSet = dataSetArray[n2];
            this.log.debug("Updating XML for dataset [" + dataSet.getId() + "]");
            do {
                fileId = "F" + ++fileCount;
            } while (this.originalAttMap.keySet().contains(fileId));
            HashMap<String, String> oldToNewIds = new HashMap<String, String>();
            org.c2Metadata.eml211.DataTableType derivedDataTable = DataTableType.Factory.newInstance();
            derivedDataTable.setEntityName(fileId);
            Map<String, AttributeType> dataTableVarIds = this.originalAttMap.containsKey(dataSet.getId()) ? this.originalAttMap.get(dataSet.getId()) : (this.originalAttMap.containsKey(dataSet.getDatasetId()) ? this.originalAttMap.get(dataSet.getDatasetId()) : (this.originalAttMap.containsKey(dataSet.getName()) ? this.originalAttMap.get(dataSet.getName()) : new HashMap<String, AttributeType>()));
            int varCount = dataTableVarIds.keySet().size();
            AttributeListType attList = derivedDataTable.addNewAttributeList();
            ArrayList<org.c2Metadata.eml211.AttributeType> attArray = new ArrayList<org.c2Metadata.eml211.AttributeType>();
            for (Variable variable : dataSet.getMetadata().getVariables()) {
            }
            for (Variable variable : dataSet.getMetadata().getVariables()) {
                String newId;
                LinkedHashSet<String> sources = new LinkedHashSet<String>();
                boolean copied = false;
                org.c2Metadata.eml211.AttributeType emlAtt = AttributeType.Factory.newInstance();
                attArray.add(emlAtt);
                if (!dataTableVarIds.containsKey(variable.getName())) {
                    this.log.trace("no variable found in the original variable map for [" + variable.getId() + "] so creating a new one");
                } else {
                    AttributeType oldAtt = dataTableVarIds.get(variable.getName());
                    if (oldAtt.getAttributeDefinition() != null) {
                        emlAtt.setAttributeDefinition(oldAtt.getAttributeDefinition());
                    }
                    if (oldAtt.getId() != null) {
                        emlAtt.setId(oldAtt.getId());
                    }
                    if (oldAtt.getMeasurementScale() != null) {
                        emlAtt.setMeasurementScale(oldAtt.getMeasurementScale());
                    }
                    copied = true;
                    sources.add(variable.getId());
                    this.log.trace("Found variable [" + variable.getId() + "] in the original variable map, adding it to derivation sources");
                }
                while (dataTableVarIds.containsKey(newId = "V" + ++varCount)) {
                }
                oldToNewIds.put(variable.getId(), newId);
                ArrayList<String> ids = new ArrayList<String>();
                ids.add(newId);
                emlAtt.setId(ids);
                emlAtt.setAttributeName(variable.getName());
                emlAtt.setAttributeDefinition(variable.getDescription());
                if (variable.getTransforms().length > 0) {
                    String label = variable.getLabel();
                    if (label != null && !label.isEmpty()) {
                        emlAtt.setAttributeDefinition(label);
                    }
                    String classificationId = variable.getClassificationId();
                    Transform[] transformArray = variable.getTransforms();
                    int n3 = transformArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Transform transform = transformArray[n4];
                        sources.addAll(transform.getSourceIds());
                        if (transform.getDescription() != null) {
                            System.out.println("transform description: " + transform.getDescription());
                        }
                        DerivationType derived = emlAtt.addNewDerivation();
                        derived.addSourceAttribute(new ArrayList(transform.getSourceIds()));
                        SDTLCommandType sdtlcommand = derived.addNewCommand();
                        sdtlcommand.setScript(transform.getOriginalCommand().getCommand());
                        TransformCommand[] transformCommandArray = transform.getAlternativeCommands();
                        int n5 = transformCommandArray.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            TransformCommand command = transformCommandArray[n6];
                            if ("sdtl-pseudocode".equals(command.getSyntax())) {
                                sdtlcommand.setPseudoCode(command.getCommand());
                            } else if ("sdtl-pojo".equals(command.getSyntax())) {
                                sdtlcommand.setSdtl(command.getCommand());
                            }
                            ++n6;
                        }
                        sources.addAll(transform.getSourceIds());
                        ++n4;
                    }
                }
                if (variable.getClassificationId() == null) continue;
                Classification classification = dataSet.getMetadata().lookupClassificationById(variable.getClassificationId());
                AttributeType.MeasurementScale scale = null;
                NonNumericDomainType nonNumericDomain = null;
                NonNumericDomainType.EnumeratedDomain enumeratedDomain = null;
                if (classification != null && classification.getCodeList() != null) {
                    for (Code code : classification.getCodeList()) {
                        if (code.isMissing()) {
                            AttributeType.MissingValueCode missingCode = emlAtt.addNewMissingValueCode();
                            missingCode.setCode(code.getCodeValue());
                            missingCode.setCodeExplanation(code.getLabel());
                            continue;
                        }
                        if (scale == null) {
                            scale = emlAtt.addNewMeasurementScale();
                            nonNumericDomain = scale.addNewNominal().addNewNonNumericDomain();
                            enumeratedDomain = nonNumericDomain.addNewEnumeratedDomain();
                        }
                        NonNumericDomainType.EnumeratedDomain.CodeDefinition codeDefinition = enumeratedDomain.addNewCodeDefinition();
                        codeDefinition.setCode(code.getCodeValue());
                        codeDefinition.setDefinition(code.getLabel());
                    }
                    continue;
                }
                scale = emlAtt.addNewMeasurementScale();
                scale.addNewNominal().addNewNonNumericDomain().addNewTextDomain().setDefinition(variable.getDescription());
            }
            this.createFileLevelTransforms(updatedDocument, dataSet, oldToNewIds);
            attList.setAttributeArray((AttributeType[])attArray.toArray(new org.c2Metadata.eml211.AttributeType[attArray.size()]));
            updatedDocument.getEml().getDataset().getDataTableList().add(derivedDataTable);
            ++n2;
        }
        return updatedDocument;
    }

    private void createFileLevelTransforms(EmlDocument updatedDocument, DataSet dataSet, Map<String, String> oldToNewIds) {
        for (FileTransform fileTransform : dataSet.getCommands()) {
            EmlDocument.Eml.AdditionalMetadata am = updatedDocument.getEml().addNewAdditionalMetadata();
            EmlDocument.Eml.AdditionalMetadata.Metadata meta = am.addNewMetadata();
            DataTableDerivationType dtDeriv = DataTableDerivationType.Factory.newInstance();
            DataTableSDTLCommandType sdtlDeriv = dtDeriv.addNewCommand();
            if (fileTransform.getTransform().getDescription() != null) {
                System.out.println(fileTransform.getTransform().getDescription());
            }
            if (fileTransform.hasDerivedVars()) {
                DerivedAttributesType vars = sdtlDeriv.addNewDerivedAttributes();
                ArrayList<String> addedVars = new ArrayList<String>();
                ArrayList<String> droppedVars = new ArrayList<String>();
                ArrayList<String> keptVars = new ArrayList<String>();
                for (String added : fileTransform.getAddedVariables()) {
                    if (oldToNewIds.containsKey(added)) {
                        addedVars.add(oldToNewIds.get(added));
                        vars.setAdd(addedVars);
                        continue;
                    }
                    vars.setAdd(new ArrayList(fileTransform.getAddedVariables()));
                }
                for (String dropped : fileTransform.getDroppedVariables()) {
                    if (oldToNewIds.containsKey(dropped)) {
                        droppedVars.add(oldToNewIds.get(dropped));
                        vars.setDrop(droppedVars);
                        continue;
                    }
                    vars.setDrop(new ArrayList(fileTransform.getDroppedVariables()));
                }
                for (String kept : fileTransform.getKeptVariables()) {
                    if (oldToNewIds.containsKey(kept)) {
                        keptVars.add(oldToNewIds.get(kept));
                        vars.setKeep(keptVars);
                        continue;
                    }
                    vars.setKeep(new ArrayList(fileTransform.getKeptVariables()));
                }
            }
            if (fileTransform.isAddCases()) {
                sdtlDeriv.setDerivedCases(FileDerivationCasesType.ADD);
            }
            if (fileTransform.isDropCases()) {
                sdtlDeriv.setDerivedCases(FileDerivationCasesType.DROP);
            }
            ArrayList<String> sourceDs = new ArrayList<String>();
            sourceDs.add(fileTransform.getSourceDataset());
            dtDeriv.addSourceDataTable(sourceDs);
            sdtlDeriv.setScript(fileTransform.getTransform().getOriginalCommand().getCommand());
            TransformCommand[] transformCommandArray = fileTransform.getTransform().getAlternativeCommands();
            int n = transformCommandArray.length;
            int n2 = 0;
            while (n2 < n) {
                TransformCommand command = transformCommandArray[n2];
                if ("sdtl-pseudocode".equals(command.getSyntax())) {
                    sdtlDeriv.setPseudoCode(command.getCommand());
                } else if ("sdtl-pojo".equals(command.getSyntax())) {
                    sdtlDeriv.setSdtl(command.getCommand());
                }
                ++n2;
            }
            meta.set((XmlObject)dtDeriv);
            XhtmlUtilities.setXhtmlContent((XmlObject)meta, (String)dtDeriv.toString());
        }
    }

    private void copyOriginalEml(EmlDocument.Eml original, EmlDocument.Eml newDocument) {
        DatasetType newDs;
        DatasetType originalDs = original.getDataset();
        if (original.getDataset() != null) {
            newDs = newDocument.getDataset();
            if (original.getDataset().getTitleList() != null) {
                for (I18NNonEmptyStringType title : original.getDataset().getTitleList()) {
                    newDs.addNewTitle().set((XmlObject)title);
                }
            }
            if (originalDs.getKeywordSetArray() != null) {
                newDs.setKeywordSetArray(originalDs.getKeywordSetArray());
            }
            if (originalDs.getAdditionalInfoArray() != null) {
                newDs.setAdditionalInfoArray(originalDs.getAdditionalInfoArray());
            }
            if (originalDs.getIntellectualRights() != null) {
                newDs.setIntellectualRights(originalDs.getIntellectualRights());
            }
            if (originalDs.getDistributionArray() != null) {
                newDs.setDistributionArray(originalDs.getDistributionArray());
            }
            if (originalDs.getCoverage() != null) {
                newDs.setCoverage(originalDs.getCoverage());
            }
            if (originalDs.getPurpose() != null) {
                newDs.setPurpose(originalDs.getPurpose());
            }
            if (originalDs.getMaintenance() != null) {
                newDs.setMaintenance(originalDs.getMaintenance());
            }
            if (originalDs.getCreatorArray() != null) {
                newDs.setCreatorArray(originalDs.getCreatorArray());
            }
            if (originalDs.getAbstract() != null) {
                newDs.addNewAbstract().set((XmlObject)originalDs.getAbstract());
            }
            if (originalDs.getContactArray() != null) {
                newDs.setContactArray(originalDs.getContactArray());
            }
            if (originalDs.getMethods() != null) {
                newDs.setMethods(originalDs.getMethods());
            }
            if (originalDs.getProject() != null) {
                newDs.setProject(originalDs.getProject());
            }
            newDs.setDataTableArray(original.getDataset().getDataTableArray());
            if (originalDs.getOtherEntityArray() != null) {
                newDs.setOtherEntityArray(originalDs.getOtherEntityArray());
            }
        }
        if (original.getCitation() != null) {
            newDs = original.getCitation();
        }
        for (DataTableType dataTable : original.getDataset().getDataTableList()) {
            HashMap<String, AttributeType> innerAttMap = new HashMap<String, AttributeType>();
            AttributeType[] attributeTypeArray = dataTable.getAttributeList().getAttributeArray();
            int n = attributeTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                AttributeType att = attributeTypeArray[n2];
                if (att.getAttributeName() != null) {
                    innerAttMap.put(att.getAttributeName(), att);
                } else if (att.getId() != null) {
                    innerAttMap.put(att.getId().get(0).toString(), att);
                } else {
                    this.log.debug("attribute identifier not found");
                }
                ++n2;
            }
            this.originalAttMap.put(dataTable.getEntityName().toString(), innerAttMap);
        }
    }

    private EmlDocument initializeDocument() {
        EmlDocument document = EmlDocument.Factory.newInstance();
        EmlDocument.Eml documentXml = document.addNewEml();
        DatasetType dsType = documentXml.addNewDataset();
        dsType.addNewTitle().addNewValue().setStringValue(this.datasetMetadata.getPopulatedTitle());
        if (!this.datasetMetadata.getAuthors().isEmpty()) {
            ResponsibleParty creator = dsType.addNewCreator();
            for (Author genericAuthoruthor : this.datasetMetadata.getAuthors()) {
                if (!(genericAuthoruthor instanceof EmlAuthor)) continue;
                EmlAuthor author = (EmlAuthor)genericAuthoruthor;
                Person person = creator.addNewIndividualName();
                if (author.getSurName() != null && !author.getSurName().isEmpty()) {
                    person.addNewSurName().addNewValue().setStringValue(author.getSurName());
                }
                if (author.getGivenNames() != null || !author.getGivenNames().isEmpty()) {
                    for (String name : author.getGivenNames()) {
                        person.addNewGivenName().addNewValue().setStringValue(name);
                    }
                }
                if (author.getAffiliation() == null) continue;
                creator.addNewOrganizationName().addNewValue().setStringValue(author.getAffiliation());
            }
        }
        return document;
    }

    @Override
    public SchemaType supports() {
        return EmlDocument.type;
    }

    public DatasetMetadata getDatasetMetadata() {
        return this.datasetMetadata;
    }

    @Override
    public void setDatasetMetadata(DatasetMetadata metadata) {
        this.datasetMetadata = metadata;
    }

    @Override
    public void setLog(Logger log) {
        this.log = log;
    }
}

