/*
 * Decompiled with CFR 0.152.
 */
package us.mtna.c2metadata.xml;

import java.util.Arrays;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlObject;
import org.ecoinformatics.eml_2_1_1.attribute.xml.xmlbeans.AttributeListType;
import org.ecoinformatics.eml_2_1_1.attribute.xml.xmlbeans.AttributeType;
import org.ecoinformatics.eml_2_1_1.attribute.xml.xmlbeans.NonNumericDomainType;
import org.ecoinformatics.eml_2_1_1.dataset.xml.xmlbeans.DatasetType;
import org.ecoinformatics.eml_2_1_1.datatable.xml.xmlbeans.DataTableType;
import org.ecoinformatics.eml_2_1_1.literature.xml.xmlbeans.CitationType;
import org.ecoinformatics.eml_2_1_1.party.xml.xmlbeans.Person;
import org.ecoinformatics.eml_2_1_1.party.xml.xmlbeans.ResponsibleParty;
import org.ecoinformatics.eml_2_1_1.resource.xml.xmlbeans.I18NNonEmptyStringType;
import org.ecoinformatics.eml_2_1_1.xml.xmlbeans.EmlDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.mtna.c2metadata.xml.XmlUpdater;
import us.mtna.pojo.Classification;
import us.mtna.pojo.Code;
import us.mtna.pojo.DataSet;
import us.mtna.pojo.Variable;
import us.mtna.updater.Author;
import us.mtna.updater.DatasetMetadata;
import us.mtna.updater.EmlAuthor;

public class EmlUpdater
implements XmlUpdater {
    private DatasetMetadata datasetMetadata;
    private String entityName = "sample entity name";
    private String entityDescription = "sample entity description";
    private Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public XmlObject updateXml(XmlObject original, DataSet ... newDataSets) {
        if (this.datasetMetadata == null) {
            this.datasetMetadata = new DatasetMetadata();
        }
        EmlDocument originalDocument = (EmlDocument)original.changeType(EmlDocument.type);
        EmlDocument updatedDocument = this.initializeDocument();
        this.copyOriginalEml(originalDocument.getEml(), updatedDocument.getEml());
        updatedDocument.getEml().setPackageId(this.datasetMetadata.getPopulatedId());
        updatedDocument.getEml().setSystem(Arrays.asList("C2M Metadata Generator"));
        DataSet[] dataSetArray = newDataSets;
        int n = newDataSets.length;
        int n2 = 0;
        while (n2 < n) {
            DataSet dataSet = dataSetArray[n2];
            DataTableType newDataTable = updatedDocument.getEml().getDataset().addNewDataTable();
            newDataTable.setEntityName(this.entityName);
            newDataTable.setEntityDescription(this.entityDescription);
            AttributeListType attList = newDataTable.addNewAttributeList();
            for (Variable variable : dataSet.getMetadata().getVariables()) {
                AttributeType attribute = attList.addNewAttribute();
                attribute.setAttributeName(variable.getName());
                attribute.setAttributeDefinition(variable.getDescription());
                if (variable.getClassificationId() == null) continue;
                Classification classification = dataSet.getMetadata().lookupClassificationById(variable.getClassificationId());
                AttributeType.MeasurementScale scale = null;
                NonNumericDomainType nonNumericDomain = null;
                NonNumericDomainType.EnumeratedDomain enumeratedDomain = null;
                if (classification != null && classification.getCodeList() != null) {
                    for (Code code : classification.getCodeList()) {
                        if (code.isMissing()) {
                            AttributeType.MissingValueCode missingCode = attribute.addNewMissingValueCode();
                            missingCode.setCode(code.getCodeValue());
                            missingCode.setCodeExplanation(code.getLabel());
                            continue;
                        }
                        if (scale == null) {
                            scale = attribute.addNewMeasurementScale();
                            nonNumericDomain = scale.addNewNominal().addNewNonNumericDomain();
                            enumeratedDomain = nonNumericDomain.addNewEnumeratedDomain();
                        }
                        NonNumericDomainType.EnumeratedDomain.CodeDefinition codeDefinition = enumeratedDomain.addNewCodeDefinition();
                        codeDefinition.setCode(code.getCodeValue());
                        codeDefinition.setDefinition(code.getLabel());
                    }
                    continue;
                }
                scale = attribute.addNewMeasurementScale();
                scale.addNewNominal().addNewNonNumericDomain().addNewTextDomain().setDefinition(variable.getDescription());
            }
            ++n2;
        }
        return updatedDocument;
    }

    private void copyOriginalEml(EmlDocument.Eml original, EmlDocument.Eml newDocument) {
        DatasetType originalDs = original.getDataset();
        if (original.getDataset() != null) {
            DatasetType newDs = newDocument.getDataset();
            if (original.getDataset().getTitleList() != null) {
                for (I18NNonEmptyStringType title : original.getDataset().getTitleList()) {
                    newDs.addNewTitle().set((XmlObject)title);
                }
            }
            if (originalDs.getKeywordSetArray() != null) {
                newDs.setKeywordSetArray(originalDs.getKeywordSetArray());
            }
            if (originalDs.getAdditionalInfoArray() != null) {
                newDs.setAdditionalInfoArray(originalDs.getAdditionalInfoArray());
            }
            if (originalDs.getIntellectualRights() != null) {
                newDs.setIntellectualRights(originalDs.getIntellectualRights());
            }
            if (originalDs.getDistributionArray() != null) {
                newDs.setDistributionArray(originalDs.getDistributionArray());
            }
            if (originalDs.getCoverage() != null) {
                newDs.setCoverage(originalDs.getCoverage());
            }
            if (originalDs.getPurpose() != null) {
                newDs.setPurpose(originalDs.getPurpose());
            }
            if (originalDs.getMaintenance() != null) {
                newDs.setMaintenance(originalDs.getMaintenance());
            }
            if (originalDs.getCreatorArray() != null) {
                newDs.setCreatorArray(originalDs.getCreatorArray());
            }
            if (originalDs.getAbstract() != null) {
                newDs.addNewAbstract().set((XmlObject)originalDs.getAbstract());
            }
            if (originalDs.getContactArray() != null) {
                newDs.setContactArray(originalDs.getContactArray());
            }
        }
        if (original.getCitation() != null) {
            CitationType citationType = original.getCitation();
        }
        for (CitationType citationType : original.getDataset().getDataTableList()) {
        }
    }

    private EmlDocument initializeDocument() {
        EmlDocument document = EmlDocument.Factory.newInstance();
        EmlDocument.Eml documentXml = document.addNewEml();
        DatasetType dsType = documentXml.addNewDataset();
        dsType.addNewTitle().addNewValue().setStringValue(this.datasetMetadata.getPopulatedTitle());
        if (!this.datasetMetadata.getAuthors().isEmpty()) {
            ResponsibleParty creator = dsType.addNewCreator();
            for (Author genericAuthoruthor : this.datasetMetadata.getAuthors()) {
                if (!(genericAuthoruthor instanceof EmlAuthor)) continue;
                EmlAuthor author = (EmlAuthor)genericAuthoruthor;
                Person person = creator.addNewIndividualName();
                if (author.getSurName() != null && !author.getSurName().isEmpty()) {
                    person.addNewSurName().addNewValue().setStringValue(author.getSurName());
                }
                if (author.getGivenNames() != null || !author.getGivenNames().isEmpty()) {
                    for (String name : author.getGivenNames()) {
                        person.addNewGivenName().addNewValue().setStringValue(name);
                    }
                }
                if (author.getAffiliation() == null) continue;
                creator.addNewOrganizationName().addNewValue().setStringValue(author.getAffiliation());
            }
        }
        return document;
    }

    @Override
    public SchemaType supports() {
        return EmlDocument.type;
    }

    public DatasetMetadata getDatasetMetadata() {
        return this.datasetMetadata;
    }

    @Override
    public void setDatasetMetadata(DatasetMetadata metadata) {
        this.datasetMetadata = metadata;
    }

    @Override
    public void setLog(Logger log) {
    }
}

