/*
 * Decompiled with CFR 0.152.
 */
package us.mtna.c2metadata.xml;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlObject;
import org.ddialliance.ddi_2_5.xml.xmlbeans.BaseElementType;
import org.ddialliance.ddi_2_5.xml.xmlbeans.CatgryType;
import org.ddialliance.ddi_2_5.xml.xmlbeans.CitationType;
import org.ddialliance.ddi_2_5.xml.xmlbeans.CodeBookDocument;
import org.ddialliance.ddi_2_5.xml.xmlbeans.CodeBookType;
import org.ddialliance.ddi_2_5.xml.xmlbeans.DataDscrType;
import org.ddialliance.ddi_2_5.xml.xmlbeans.DerivationType;
import org.ddialliance.ddi_2_5.xml.xmlbeans.DrvcmdType;
import org.ddialliance.ddi_2_5.xml.xmlbeans.FileDscrType;
import org.ddialliance.ddi_2_5.xml.xmlbeans.MaterialReferenceType;
import org.ddialliance.ddi_2_5.xml.xmlbeans.OthrStdyMatType;
import org.ddialliance.ddi_2_5.xml.xmlbeans.ProdStmtType;
import org.ddialliance.ddi_2_5.xml.xmlbeans.SimpleTextAndDateType;
import org.ddialliance.ddi_2_5.xml.xmlbeans.SoftwareType;
import org.ddialliance.ddi_2_5.xml.xmlbeans.StdyDscrType;
import org.ddialliance.ddi_2_5.xml.xmlbeans.TitlStmtType;
import org.ddialliance.ddi_2_5.xml.xmlbeans.VarType;
import org.ddialliance.ddi_2_5.xml.xmlbeans.VerStmtType;
import org.openmetadata.util.xmlbeans.XhtmlUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.mtna.c2metadata.xml.XmlUpdater;
import us.mtna.pojo.Classification;
import us.mtna.pojo.Code;
import us.mtna.pojo.DataSet;
import us.mtna.pojo.Metadata;
import us.mtna.pojo.Transform;
import us.mtna.pojo.TransformCommand;
import us.mtna.pojo.Variable;
import us.mtna.updater.Author;
import us.mtna.updater.DatasetMetadata;
import us.mtna.updater.DdiAuthor;

public class Ddi25XmlUpdater
implements XmlUpdater {
    private HashSet<String> fileIds;
    private HashMap<String, VarType> originalVarMap;
    private Logger log = LoggerFactory.getLogger(Ddi25XmlUpdater.class);
    private DatasetMetadata datasetMetadata;
    private static String SOFTWARE_VERSION = "1.1.2";
    private static String SOFTWARE_NAME = "C2Metadata XML Updater";
    private static String DOCUMENT_ID = "SAMPLE_XU_OUTPUT";

    public Ddi25XmlUpdater() {
        this.fileIds = new HashSet();
        this.originalVarMap = new HashMap();
    }

    @Override
    public XmlObject updateXml(XmlObject original, DataSet ... newDataSets) {
        if (this.datasetMetadata == null) {
            this.datasetMetadata = new DatasetMetadata();
        }
        CodeBookDocument originalDocument = (CodeBookDocument)original.changeType(CodeBookDocument.type);
        CodeBookDocument updatedDocument = this.initializeDocument();
        this.copyOriginalXml(originalDocument.getCodeBook(), updatedDocument.getCodeBook());
        int varCount = this.originalVarMap.size();
        int fileCount = this.fileIds.size();
        DataSet[] dataSetArray = newDataSets;
        int n = newDataSets.length;
        int n2 = 0;
        while (n2 < n) {
            String fileId;
            DataSet dataSet = dataSetArray[n2];
            this.log.debug("Updating XML for dataset [" + dataSet.getId() + "]");
            while (this.fileIds.contains(fileId = "F" + ++fileCount)) {
            }
            FileDscrType fileDscr = updatedDocument.getCodeBook().addNewFileDscr();
            fileDscr.setID(fileId);
            DataDscrType dataDscr = updatedDocument.getCodeBook().addNewDataDscr();
            Metadata metadata = dataSet.getMetadata();
            int fileVarCount = 0;
            for (Variable variable : metadata.getVariables()) {
                String newId;
                VarType var = this.originalVarMap.get(variable.getId());
                LinkedHashSet<String> sources = new LinkedHashSet<String>();
                boolean copied = false;
                if (var == null) {
                    var = dataDscr.addNewVar();
                    this.log.trace("no variable found in the original variable map for [" + variable.getId() + "] so creating a new one");
                } else {
                    copied = true;
                    sources.add(var.getID());
                    this.log.trace("Found variable [" + variable.getId() + "] in the original variable map, adding it to derivation sources");
                }
                while (this.originalVarMap.containsKey(newId = "V" + ++varCount)) {
                }
                var.setID(newId);
                DerivationType derivation = var.addNewDerivation();
                if (variable.getTransforms().length > 0) {
                    String classificationId;
                    var.setName(variable.getName());
                    var.getLablList().clear();
                    String label = variable.getLabel();
                    if (label != null && !label.isEmpty()) {
                        XhtmlUtilities.setXhtmlContent((XmlObject)var.addNewLabl(), (String)label);
                    }
                    if ((classificationId = variable.getClassificationId()) != null && !classificationId.isEmpty()) {
                        var.getCatgryList().clear();
                        Classification classification = (Classification)metadata.getClassifs().get(classificationId);
                        if (classification != null) {
                            for (Code code : classification.getCodeList()) {
                                CatgryType catgry = var.addNewCatgry();
                                XhtmlUtilities.setXhtmlContent((XmlObject)catgry.addNewCatValu(), (String)code.getCodeValue());
                                String codeLabel = code.getLabel();
                                if (codeLabel != null && !codeLabel.isEmpty()) {
                                    XhtmlUtilities.setXhtmlContent((XmlObject)catgry.addNewLabl(), (String)codeLabel);
                                }
                                if (!code.isMissing()) continue;
                                catgry.setMissing(CatgryType.Missing.Enum.forInt((int)1));
                            }
                        }
                    } else {
                        this.log.debug("No classification found on variable [" + variable.getId() + "]");
                    }
                    Transform[] transformArray = variable.getTransforms();
                    int n3 = transformArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Transform transform = transformArray[n4];
                        sources.addAll(transform.getSourceIds());
                        if (transform.getDescription() != null) {
                            XhtmlUtilities.setXhtmlContent((XmlObject)derivation.addNewDrvdesc(), (String)transform.getDescription());
                        }
                        DrvcmdType drvcmd = derivation.addNewDrvcmd();
                        drvcmd.setSource(BaseElementType.Source.PRODUCER);
                        drvcmd.setSyntax(transform.getOriginalCommand().getSyntax());
                        XhtmlUtilities.setXhtmlContent((XmlObject)drvcmd, (String)transform.getOriginalCommand().getCommand());
                        TransformCommand[] transformCommandArray = transform.getAlternativeCommands();
                        int n5 = transformCommandArray.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            TransformCommand command = transformCommandArray[n6];
                            if ("sdtl-pseudocode".equals(command.getSyntax())) {
                                XhtmlUtilities.setXhtmlContent((XmlObject)derivation.addNewDrvdesc(), (String)command.getCommand());
                            } else {
                                drvcmd = derivation.addNewDrvcmd();
                                drvcmd.setSource(BaseElementType.Source.ARCHIVE);
                                drvcmd.setSyntax(command.getSyntax());
                                XhtmlUtilities.setXhtmlContent((XmlObject)drvcmd, (String)command.getCommand());
                            }
                            ++n6;
                        }
                        ++n4;
                    }
                }
                derivation.setVar(new ArrayList(sources));
                if (!variable.isDeleted()) {
                    ++fileVarCount;
                    var.setFiles(Arrays.asList(fileId));
                }
                if (!copied) continue;
                dataDscr.getVarList().add(var);
            }
            this.addCitations(Arrays.asList(originalDocument), updatedDocument);
            XhtmlUtilities.setXhtmlContent((XmlObject)fileDscr.addNewFileTxt().addNewDimensns().addNewVarQnty(), (String)String.valueOf(fileVarCount));
            ++n2;
        }
        return updatedDocument;
    }

    @Override
    public SchemaType supports() {
        return CodeBookDocument.type;
    }

    private CodeBookDocument initializeDocument() {
        CodeBookDocument document = CodeBookDocument.Factory.newInstance();
        CodeBookType documentXml = document.addNewCodeBook();
        documentXml.setID(DOCUMENT_ID);
        CitationType citation = documentXml.addNewStdyDscr().addNewCitation();
        ProdStmtType prodStmt = citation.addNewProdStmt();
        SimpleTextAndDateType prodDate = prodStmt.addNewProdDate();
        LocalDate now = LocalDate.now();
        prodDate.setDate(now.toString());
        XhtmlUtilities.setXhtmlContent((XmlObject)prodDate, (String)now.toString());
        SoftwareType software = prodStmt.addNewSoftware();
        software.setVersion(SOFTWARE_VERSION);
        software.setDate(now.toString());
        XhtmlUtilities.setXhtmlContent((XmlObject)software, (String)SOFTWARE_NAME);
        return document;
    }

    private void copyOriginalXml(CodeBookType original, CodeBookType updated) {
        for (FileDscrType fileDscr : original.getFileDscrList()) {
            this.fileIds.add(fileDscr.getID());
            updated.getFileDscrList().add((FileDscrType)fileDscr.copy());
        }
        for (DataDscrType dataDscr : original.getDataDscrList()) {
            updated.getDataDscrList().add((DataDscrType)dataDscr.copy());
            for (VarType var : dataDscr.getVarList()) {
                int ivr;
                var = (VarType)var.copy();
                var.getSumStatList().clear();
                var.getLocationList().clear();
                var.unsetFiles();
                int vr = var.sizeOfValrngArray();
                if (vr > 0) {
                    var.removeValrng(vr - 1);
                }
                if ((ivr = var.sizeOfInvalrngArray()) > 0) {
                    var.removeInvalrng(ivr - 1);
                }
                for (CatgryType cat : var.getCatgryList()) {
                    cat.getCatStatList().clear();
                }
                this.originalVarMap.put(var.getID(), var);
            }
        }
    }

    private void addCitations(Collection<CodeBookDocument> documents, CodeBookDocument newDoc) {
        StdyDscrType newDocStdy = (StdyDscrType)newDoc.getCodeBook().getStdyDscrList().get(0);
        OthrStdyMatType other = newDocStdy.addNewOthrStdyMat();
        for (CodeBookDocument cbd : documents) {
            ArrayList<CitationType> citations = new ArrayList<CitationType>();
            MaterialReferenceType relStdy = other.addNewRelStdy();
            for (StdyDscrType sdt : cbd.getCodeBook().getStdyDscrList()) {
                for (CitationType citation : sdt.getCitationList()) {
                    citations.add(citation);
                }
                relStdy.setCitationArray(citations.toArray(new CitationType[0]));
            }
        }
        CitationType citation = (CitationType)newDocStdy.getCitationList().get(0);
        TitlStmtType titleType = citation.addNewTitlStmt();
        String title = null;
        if (this.datasetMetadata.getDocumentTitle() == null || this.datasetMetadata.getDocumentTitle().isEmpty()) {
            if (!this.fileIds.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Metadata File Created by the C2Metadata Updater From ");
                if (this.fileIds.size() > 1) {
                    sb.append("Files: ");
                } else {
                    sb.append("File ");
                }
                for (String id : this.fileIds) {
                    sb.append(id).append(", ");
                }
                sb.setLength(sb.length() - 2);
                title = sb.toString();
            } else {
                title = "updatedMetadata.xml";
            }
        }
        XhtmlUtilities.setXhtmlContent((XmlObject)titleType.addNewTitl(), (String)title);
        if (this.datasetMetadata.getDocumentId() != null && !this.datasetMetadata.getDocumentId().isEmpty()) {
            XhtmlUtilities.setXhtmlContent((XmlObject)titleType.addNewIDNo(), (String)this.datasetMetadata.getDocumentId());
        }
        if (!this.datasetMetadata.getAuthors().isEmpty()) {
            ProdStmtType prod = citation.getProdStmt();
            for (Author author : this.datasetMetadata.getAuthors()) {
                DdiAuthor ddiAuthor;
                if (!(author instanceof DdiAuthor) || (ddiAuthor = (DdiAuthor)author).getFullName() == null || ddiAuthor.getFullName().isEmpty()) continue;
                XhtmlUtilities.setXhtmlContent((XmlObject)prod.addNewProducer(), (String)ddiAuthor.getFullName());
            }
        }
        VerStmtType ver = citation.addNewVerStmt();
        XhtmlUtilities.setXhtmlContent((XmlObject)ver.addNewVersion(), (String)"VERSION OF DATASET RESULTED FROM TRANSFORMATION (EX: V1)");
        XhtmlUtilities.setXhtmlContent((XmlObject)ver.addNewNotes(), (String)"Data from this study were used in the transformations described in this DDI Instance ");
    }

    @Override
    public void setDatasetMetadata(DatasetMetadata metadata) {
        this.datasetMetadata = metadata;
    }

    public DatasetMetadata getDatasetMetadata() {
        return this.datasetMetadata;
    }

    @Override
    public void setLog(Logger log) {
        this.log = log;
    }

    public Logger getLog() {
        return this.log;
    }
}

