/*
 * Decompiled with CFR 0.152.
 */
package us.mtna.data.transform.wrapper.sdtl;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.c2metadata.sdtl.pojo.FunctionArgument;
import org.c2metadata.sdtl.pojo.command.TransformBase;
import org.c2metadata.sdtl.pojo.expression.BooleanConstantExpression;
import org.c2metadata.sdtl.pojo.expression.FunctionCallExpression;
import org.c2metadata.sdtl.pojo.expression.GroupedExpression;
import org.c2metadata.sdtl.pojo.expression.IteratorSymbolExpression;
import org.c2metadata.sdtl.pojo.expression.MissingValueConstantExpression;
import org.c2metadata.sdtl.pojo.expression.NumberRangeExpression;
import org.c2metadata.sdtl.pojo.expression.NumericConstantExpression;
import org.c2metadata.sdtl.pojo.expression.StringConstantExpression;
import org.c2metadata.sdtl.pojo.expression.StringRangeExpression;
import org.c2metadata.sdtl.pojo.expression.ValueListExpression;
import org.c2metadata.sdtl.pojo.expression.VariableRangeExpression;
import org.c2metadata.sdtl.pojo.expression.VariableSymbolExpression;
import us.mtna.data.transform.command.CreatesVariables;
import us.mtna.data.transform.command.SelectsVariables;
import us.mtna.data.transform.command.object.NewVariable;
import us.mtna.data.transform.command.object.Range;
import us.mtna.data.transform.wrapper.sdtl.ValidationResult;

public class Compute
implements SelectsVariables,
CreatesVariables {
    private final org.c2metadata.sdtl.pojo.command.Compute sdtl;

    public Compute(org.c2metadata.sdtl.pojo.command.Compute sdtl) {
        this.sdtl = sdtl;
    }

    @Override
    public ValidationResult validate() {
        ValueListExpression expr;
        ValidationResult result = new ValidationResult();
        if (this.sdtl.getExpression() == null) {
            result.addMessages("No expression to evaluate on command [" + this.sdtl.getSourceInformationConcatenatedCommandText() + "]");
            result.setValid(false);
        } else if (this.sdtl.getExpression() instanceof FunctionCallExpression) {
            FunctionCallExpression fc = (FunctionCallExpression)this.sdtl.getExpression();
            if (fc.getArguments() != null) {
                FunctionArgument[] functionArgumentArray = fc.getArguments();
                int n = functionArgumentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    FunctionArgument arg = functionArgumentArray[n2];
                    if (arg.getArgumentName() == null) {
                        result.addMessages("No argument name found on FunctionArgument");
                        result.setValid(false);
                    }
                    if (arg.getArgumentValue() == null) {
                        result.addMessages("No argument value found on FunctionArgument");
                        result.setValid(false);
                    }
                    ++n2;
                }
            }
        } else if (this.sdtl.getExpression() instanceof NumberRangeExpression) {
            NumberRangeExpression nre = (NumberRangeExpression)this.sdtl.getExpression();
            if (nre.getNumberRangeStart() == null) {
                result.addMessages("No number range start found on NumberRangeExpression");
                result.setValid(false);
            }
            if (nre.getNumberRangeEnd() == null) {
                result.addMessages("No number range end found on NumberRangeExpression");
                result.setValid(false);
            }
            if (nre.getNumberRangeIncrement() == null) {
                result.addMessages("No number range increment found on NumberRangeExpression");
                result.setValid(false);
            }
        } else if (this.sdtl.getExpression() instanceof NumericConstantExpression) {
            NumericConstantExpression nce = (NumericConstantExpression)this.sdtl.getExpression();
            if (nce.getValue() == null) {
                result.addMessages("No value found on NumericConstantExpression");
                result.setValid(false);
            }
            if (nce.getNumericType() == null) {
                result.addMessages("No numeric type found on NumericConstantExpression");
                result.setValid(false);
            }
        } else if (this.sdtl.getExpression() instanceof BooleanConstantExpression) {
            BooleanConstantExpression bce = (BooleanConstantExpression)this.sdtl.getExpression();
            if (bce.getValue() == null) {
                result.addMessages("No value found on BooleanConstantExpression");
                result.setValid(false);
            }
        } else if (this.sdtl.getExpression() instanceof GroupedExpression) {
            GroupedExpression expr2 = (GroupedExpression)this.sdtl.getExpression();
            if (expr2.getExpression() == null) {
                result.addMessages("No expression found on GroupedExpression");
                result.setValid(false);
            }
        } else if (this.sdtl.getExpression() instanceof IteratorSymbolExpression) {
            IteratorSymbolExpression expr3 = (IteratorSymbolExpression)this.sdtl.getExpression();
            if (expr3.getName() == null) {
                result.addMessages("No name found on IteratorSymbolExpression");
                result.setValid(false);
            }
        } else if (this.sdtl.getExpression() instanceof MissingValueConstantExpression) {
            MissingValueConstantExpression expr4 = (MissingValueConstantExpression)this.sdtl.getExpression();
            if (expr4.getValue() == null) {
                result.addMessages("No value found on MissingValueConstantExpression");
                result.setValid(false);
            }
        } else if (this.sdtl.getExpression() instanceof StringConstantExpression) {
            StringConstantExpression expr5 = (StringConstantExpression)this.sdtl.getExpression();
            if (expr5.getValue() == null) {
                result.addMessages("No value found on StringConstantExpression");
                result.setValid(false);
            }
        } else if (this.sdtl.getExpression() instanceof StringRangeExpression) {
            StringRangeExpression expr6 = (StringRangeExpression)this.sdtl.getExpression();
            if (expr6.getRangeEnd() == null) {
                result.addMessages("No range end found on StringRangeExpression");
                result.setValid(false);
            }
            if (expr6.getRangeStart() == null) {
                result.addMessages("No range start found on StringRangeExpression");
                result.setValid(false);
            }
        } else if (this.sdtl.getExpression() instanceof ValueListExpression && (expr = (ValueListExpression)this.sdtl.getExpression()).getValues() == null) {
            result.addMessages("No values end found on ValueListExpression");
            result.setValid(false);
        }
        if (this.sdtl.getVariable() == null) {
            result.addMessages("No variable to compute found on command [" + this.sdtl.getSourceInformationConcatenatedCommandText() + "]");
            result.setValid(false);
        }
        return result;
    }

    @Override
    public boolean preserveOriginalVariable() {
        return false;
    }

    @Override
    public TransformBase getOriginalCommand() {
        return this.sdtl;
    }

    @Override
    public List<Range> getRanges() {
        return this.getRangesFromVariableReferenceBase(this.sdtl.getVariable());
    }

    @Override
    public Set<String> getVariables() {
        return this.getVariablesFromVariableReferenceBase(this.sdtl.getVariable());
    }

    @Override
    public NewVariable[] getNewVariables() {
        ArrayList<NewVariable> newVars = new ArrayList<NewVariable>();
        if (this.sdtl.getVariable() != null) {
            NewVariable newVar = new NewVariable();
            if (VariableSymbolExpression.class.isAssignableFrom(this.sdtl.getVariable().getClass())) {
                VariableSymbolExpression symbol = (VariableSymbolExpression)this.sdtl.getVariable();
                if (symbol.getVariableName() != null) {
                    newVar.setNewVariableName(symbol.getVariableName());
                }
                newVar = this.parseSourceVariables(this.sdtl.getExpression(), newVar);
                newVars.add(newVar);
            } else if (VariableRangeExpression.class.isAssignableFrom(this.sdtl.getVariable().getClass())) {
                VariableRangeExpression rangeExpr = (VariableRangeExpression)this.sdtl.getVariable();
                Range range = new Range();
                if (rangeExpr.getFirst() != null) {
                    range.setStart(rangeExpr.getFirst());
                }
                if (rangeExpr.getLast() != null) {
                    range.setEnd(rangeExpr.getLast());
                }
                newVar.setSourceVariableRange(range);
                newVars.add(newVar);
            }
        }
        return newVars.toArray(new NewVariable[newVars.size()]);
    }
}

