/*
 * Decompiled with CFR 0.152.
 */
package us.mtna.pojo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import us.mtna.data.transform.command.object.FileDetails;
import us.mtna.pojo.Attribute;
import us.mtna.pojo.FileTransform;
import us.mtna.pojo.Metadata;
import us.mtna.pojo.ResourceImpl;
import us.mtna.pojo.Variable;
import us.mtna.updater.Citation;

public class DataSet
extends ResourceImpl {
    private Metadata metadata;
    private ArrayList<FileTransform> transforms = new ArrayList();
    private FileDetails fileDetails;
    private int recordCount;
    private String scriptName;
    private Citation<?> citation;
    private String datasetId;

    public DataSet() {
        this.metadata = new Metadata();
        this.fileDetails = new FileDetails();
    }

    public FileDetails getFile() {
        return this.fileDetails;
    }

    public void setFileDetails(FileDetails file) {
        this.fileDetails = file;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public String getDatasetId() {
        return this.datasetId;
    }

    public void setDatasetId(String key) {
        this.datasetId = key;
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    public void setRecordCount(int recordCount) {
        this.recordCount = recordCount;
    }

    public ArrayList<FileTransform> getCommands() {
        return this.transforms;
    }

    public void setCommands(ArrayList<FileTransform> commands) {
        this.transforms.clear();
        this.transforms.addAll(commands);
    }

    public void addCommands(FileTransform ... commands) {
        FileTransform[] fileTransformArray = commands;
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            FileTransform transform = fileTransformArray[n2];
            this.transforms.add(transform);
            ++n2;
        }
    }

    public Citation<?> getCitation() {
        return this.citation;
    }

    public void setCitation(Citation<?> citation) {
        this.citation = citation;
    }

    public String getScriptName() {
        return this.scriptName;
    }

    public void setScriptName(String scriptName) {
        this.scriptName = scriptName;
    }

    @Override
    public List<Attribute<?>> getAttributes() {
        List<Attribute<?>> attributes = super.getAttributes();
        Attribute<Metadata> metadataAttribute = new Attribute<Metadata>(Metadata.class);
        if (this.metadata != null) {
            metadataAttribute.setName("Metadata");
            metadataAttribute.setValue(this.metadata);
            attributes.add(metadataAttribute);
        }
        return attributes;
    }

    public List<Variable> getVariablesInRange(String from, String to) {
        Map<String, Variable> originalMap = this.metadata.getVarNameMap();
        ArrayList<Variable> vars = new ArrayList<Variable>();
        HashMap<String, Variable> varMap = new HashMap<String, Variable>();
        for (Map.Entry<String, Variable> entry : originalMap.entrySet()) {
            varMap.put(entry.getKey().toUpperCase(), entry.getValue());
        }
        boolean useStartPosition = true;
        for (Variable variable : varMap.values()) {
            if (variable.getStartPosition() != null) continue;
            useStartPosition = false;
            break;
        }
        ArrayList<Variable> sortedVars = new ArrayList<Variable>(this.metadata.getVariables());
        if (useStartPosition) {
            Collections.sort(sortedVars, Variable.StartPositionComparator);
        }
        Variable mapFirst = (Variable)varMap.get(from.toUpperCase());
        Variable mapLast = (Variable)varMap.get(to.toUpperCase());
        int toIndex = sortedVars.indexOf(mapLast);
        int fromIndex = sortedVars.indexOf(mapFirst);
        List subList = sortedVars.subList(fromIndex, toIndex + 1);
        for (Variable variable : subList) {
            vars.add(variable);
        }
        return vars;
    }
}

