/*
 * Decompiled with CFR 0.152.
 */
package us.mtna.data.transform.wrapper.sdtl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.c2metadata.sdtl.pojo.SortCriterion;
import org.c2metadata.sdtl.pojo.command.TransformBase;
import us.mtna.data.transform.command.SelectsVariables;
import us.mtna.data.transform.command.ds.ReordersDataset;
import us.mtna.data.transform.command.object.Range;
import us.mtna.data.transform.wrapper.sdtl.ValidationResult;

public class SortCases
implements SelectsVariables,
ReordersDataset {
    private final org.c2metadata.sdtl.pojo.command.SortCases sdtl;

    public SortCases(org.c2metadata.sdtl.pojo.command.SortCases sdtl) {
        this.sdtl = sdtl;
    }

    @Override
    public TransformBase getOriginalCommand() {
        return this.sdtl;
    }

    @Override
    public ValidationResult validate() {
        ValidationResult result = new ValidationResult();
        if (this.sdtl.getSortCriteria() == null || this.sdtl.getSortCriteria().length < 1) {
            result.setValid(false);
            result.addMessages("No SortCriteria found on the SortCases command [" + this.sdtl.getSourceInformationConcatenatedCommandText() + "]");
        } else {
            int i = 0;
            SortCriterion[] sortCriterionArray = this.sdtl.getSortCriteria();
            int n = sortCriterionArray.length;
            int n2 = 0;
            while (n2 < n) {
                SortCriterion crit = sortCriterionArray[n2];
                if (crit.getVariable() == null) {
                    result.setValid(false);
                    result.addMessages("No variable found on the SortCriterion at index [ " + i + " ] on command [" + this.sdtl.getSourceInformationConcatenatedCommandText() + "]");
                }
                if (crit.getSortDirection() == null) {
                    result.setValid(false);
                    result.addMessages("No sort direction found on the SortCriterion at index [ " + i + " ] on command [" + this.sdtl.getSourceInformationConcatenatedCommandText() + "]");
                }
                ++i;
                ++n2;
            }
        }
        return result;
    }

    @Override
    public List<Range> getRanges() {
        ArrayList<Range> vars = new ArrayList<Range>();
        SortCriterion[] sortCriterionArray = this.sdtl.getSortCriteria();
        int n = sortCriterionArray.length;
        int n2 = 0;
        while (n2 < n) {
            SortCriterion crit = sortCriterionArray[n2];
            vars.addAll(this.getRangesFromVariableReferenceBase(crit.getVariable()));
            ++n2;
        }
        return vars;
    }

    @Override
    public Set<String> getVariables() {
        LinkedHashSet<String> vars = new LinkedHashSet<String>();
        SortCriterion[] sortCriterionArray = this.sdtl.getSortCriteria();
        int n = sortCriterionArray.length;
        int n2 = 0;
        while (n2 < n) {
            SortCriterion crit = sortCriterionArray[n2];
            vars.addAll(this.getVariablesFromVariableReferenceBase(crit.getVariable()));
            ++n2;
        }
        return vars;
    }

    @Override
    public Set<String> getVariableOrder() {
        return new HashSet<String>();
    }

    @Override
    public Set<String> getSortingVariables() {
        HashSet<String> vars = new HashSet<String>();
        SortCriterion[] sortCriterionArray = this.sdtl.getSortCriteria();
        int n = sortCriterionArray.length;
        int n2 = 0;
        while (n2 < n) {
            SortCriterion criterion = sortCriterionArray[n2];
            vars.add(this.getVariablesFromVariableReferenceBase(criterion.getVariable()).iterator().next());
            ++n2;
        }
        return vars;
    }
}

