/*
 * Decompiled with CFR 0.152.
 */
package us.mtna.data.transform.wrapper.sdtl;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.c2metadata.sdtl.pojo.ValueLabel;
import org.c2metadata.sdtl.pojo.command.TransformBase;
import us.mtna.data.transform.command.SelectsVariables;
import us.mtna.data.transform.command.UpdatesClassification;
import us.mtna.data.transform.command.object.ClassificationUpdate;
import us.mtna.data.transform.command.object.CodeDetail;
import us.mtna.data.transform.command.object.Range;
import us.mtna.data.transform.wrapper.sdtl.ValidationResult;

public class SetValueLabels
implements SelectsVariables,
UpdatesClassification {
    private final org.c2metadata.sdtl.pojo.command.SetValueLabels sdtl;
    private boolean requiresCopyOfClassification;
    private boolean copyFloatingCodes;

    public SetValueLabels(org.c2metadata.sdtl.pojo.command.SetValueLabels sdtl) {
        this.sdtl = sdtl;
        this.requiresCopyOfClassification = false;
        this.copyFloatingCodes = true;
    }

    @Override
    public ValidationResult validate() {
        ValidationResult result = new ValidationResult();
        if (this.sdtl.getLabels() == null || this.sdtl.getLabels().length < 1) {
            result.setValid(false);
            result.addMessages("SetValueLabels SDTL does not have any value labels to assign in command [" + this.sdtl.getSourceInformationConcatenatedCommandText() + "]");
        }
        if (this.sdtl.getVariables() == null || this.sdtl.getVariables().length < 1) {
            result.setValid(false);
            result.addMessages("SetValueLabels SDTL does not define any variables in command [" + this.sdtl.getSourceInformationConcatenatedCommandText() + "]");
        }
        return result;
    }

    @Override
    public TransformBase getOriginalCommand() {
        return this.sdtl;
    }

    @Override
    public List<Range> getRanges() {
        return this.getRangesFromVariableReferenceBaseArray(this.sdtl.getVariables());
    }

    @Override
    public Set<String> getVariables() {
        return this.getVariablesFromVariableReferenceBaseArray(this.sdtl.getVariables());
    }

    @Override
    public ClassificationUpdate getUpdate() {
        ClassificationUpdate update = new ClassificationUpdate();
        ArrayList<CodeDetail> updatesCodes = new ArrayList<CodeDetail>();
        if (this.sdtl.getLabels() != null) {
            ValueLabel[] valueLabelArray = this.sdtl.getLabels();
            int n = valueLabelArray.length;
            int n2 = 0;
            while (n2 < n) {
                ValueLabel pair = valueLabelArray[n2];
                CodeDetail detail = new CodeDetail();
                detail.setLabel(pair.getLabel());
                detail.setNewValue(pair.getValue());
                detail.setFromValue(pair.getValue());
                updatesCodes.add(detail);
                ++n2;
            }
        }
        update.setUpdatesCodes(updatesCodes.toArray(new CodeDetail[updatesCodes.size()]));
        return update;
    }

    @Override
    public boolean requiresCopyOfClassification() {
        return this.requiresCopyOfClassification;
    }

    public void setRequiresCopyOfClassification(boolean requiresCopyOfClassification) {
        this.requiresCopyOfClassification = requiresCopyOfClassification;
    }

    @Override
    public boolean copyFloatingCodes() {
        return this.copyFloatingCodes;
    }

    public void setCopyFloatingCodes(boolean copyFloatingCodes) {
        this.copyFloatingCodes = copyFloatingCodes;
    }
}

