/*
 * Decompiled with CFR 0.152.
 */
package us.mtna.data.transform.command;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.c2metadata.sdtl.pojo.CompositeVariableName;
import org.c2metadata.sdtl.pojo.FunctionArgument;
import org.c2metadata.sdtl.pojo.command.CommandBase;
import org.c2metadata.sdtl.pojo.command.TransformBase;
import org.c2metadata.sdtl.pojo.expression.AllVariablesExpression;
import org.c2metadata.sdtl.pojo.expression.ExpressionBase;
import org.c2metadata.sdtl.pojo.expression.FunctionCallExpression;
import org.c2metadata.sdtl.pojo.expression.GroupedExpression;
import org.c2metadata.sdtl.pojo.expression.MissingValueConstantExpression;
import org.c2metadata.sdtl.pojo.expression.NumericConstantExpression;
import org.c2metadata.sdtl.pojo.expression.NumericMaximumValueExpression;
import org.c2metadata.sdtl.pojo.expression.NumericMinimumValueExpression;
import org.c2metadata.sdtl.pojo.expression.StringConstantExpression;
import org.c2metadata.sdtl.pojo.expression.VariableListExpression;
import org.c2metadata.sdtl.pojo.expression.VariableRangeExpression;
import org.c2metadata.sdtl.pojo.expression.VariableReferenceBase;
import org.c2metadata.sdtl.pojo.expression.VariableSymbolExpression;
import us.mtna.data.transform.command.object.MinMax;
import us.mtna.data.transform.command.object.NewVariable;
import us.mtna.data.transform.command.object.Range;
import us.mtna.data.transform.wrapper.sdtl.Compute;
import us.mtna.data.transform.wrapper.sdtl.ValidationResult;
import us.mtna.data.transform.wrapper.sdtl.WrapperFactory;

public interface SdtlWrapper {
    public CommandBase getOriginalCommand();

    public ValidationResult validate();

    default public Set<String> parseExpression(ExpressionBase base) {
        HashSet<String> value;
        block3: {
            block8: {
                block7: {
                    block6: {
                        block5: {
                            block4: {
                                block2: {
                                    value = new HashSet<String>();
                                    if (!NumericConstantExpression.class.isAssignableFrom(base.getClass())) break block2;
                                    NumericConstantExpression expr = (NumericConstantExpression)base;
                                    value.add(expr.getValue());
                                    break block3;
                                }
                                if (!StringConstantExpression.class.isAssignableFrom(base.getClass())) break block4;
                                StringConstantExpression expr = (StringConstantExpression)base;
                                value.add(expr.getValue());
                                break block3;
                            }
                            if (!MissingValueConstantExpression.class.isAssignableFrom(base.getClass())) break block5;
                            MissingValueConstantExpression expr = (MissingValueConstantExpression)base;
                            value.add(expr.getValue());
                            break block3;
                        }
                        if (!VariableSymbolExpression.class.isAssignableFrom(base.getClass())) break block6;
                        VariableSymbolExpression expr = (VariableSymbolExpression)base;
                        value.add(expr.getVariableName());
                        break block3;
                    }
                    if (!VariableListExpression.class.isAssignableFrom(base.getClass())) break block7;
                    VariableListExpression expr = (VariableListExpression)base;
                    VariableReferenceBase[] variableReferenceBaseArray = expr.getVariables();
                    int n = variableReferenceBaseArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        VariableReferenceBase inner = variableReferenceBaseArray[n2];
                        value.addAll(this.parseExpression((ExpressionBase)inner));
                        ++n2;
                    }
                    break block3;
                }
                if (!CompositeVariableName.class.isAssignableFrom(base.getClass())) break block8;
                CompositeVariableName expr = (CompositeVariableName)base;
                value.add(expr.getStub());
                break block3;
            }
            if (!FunctionCallExpression.class.isAssignableFrom(base.getClass())) break block3;
            FunctionCallExpression expr = (FunctionCallExpression)base;
            FunctionArgument[] functionArgumentArray = expr.getArguments();
            int n = functionArgumentArray.length;
            int n3 = 0;
            while (n3 < n) {
                FunctionArgument arg = functionArgumentArray[n3];
                value.addAll(this.parseExpression(arg.getArgumentValue()));
                ++n3;
            }
        }
        return value;
    }

    default public NewVariable parseSourceVariables(ExpressionBase base, NewVariable value) {
        if (NumericConstantExpression.class.isAssignableFrom(base.getClass())) {
            NumericConstantExpression expr = (NumericConstantExpression)base;
            value.addSourceVariables(expr.getValue());
        } else if (StringConstantExpression.class.isAssignableFrom(base.getClass())) {
            StringConstantExpression expr = (StringConstantExpression)base;
            value.addSourceVariables(expr.getValue());
            value.setBasisVariableName(expr.getValue());
        } else if (MissingValueConstantExpression.class.isAssignableFrom(base.getClass())) {
            MissingValueConstantExpression expr = (MissingValueConstantExpression)base;
            value.addSourceVariables(expr.getValue());
        } else if (VariableSymbolExpression.class.isAssignableFrom(base.getClass())) {
            VariableSymbolExpression expr = (VariableSymbolExpression)base;
            value.addSourceVariables(expr.getVariableName());
            value.setBasisVariableName(expr.getVariableName());
        } else if (VariableListExpression.class.isAssignableFrom(base.getClass())) {
            VariableListExpression expr = (VariableListExpression)base;
            VariableReferenceBase[] variableReferenceBaseArray = expr.getVariables();
            int n = variableReferenceBaseArray.length;
            int n2 = 0;
            while (n2 < n) {
                VariableReferenceBase inner = variableReferenceBaseArray[n2];
                this.parseSourceVariables((ExpressionBase)inner, value);
                ++n2;
            }
        } else if (CompositeVariableName.class.isAssignableFrom(base.getClass())) {
            CompositeVariableName expr = (CompositeVariableName)base;
            value.addSourceVariables(expr.getStub());
        } else if (FunctionCallExpression.class.isAssignableFrom(base.getClass())) {
            FunctionCallExpression expr = (FunctionCallExpression)base;
            FunctionArgument[] functionArgumentArray = expr.getArguments();
            int n = functionArgumentArray.length;
            int n3 = 0;
            while (n3 < n) {
                FunctionArgument arg = functionArgumentArray[n3];
                this.parseSourceVariables(arg.getArgumentValue(), value);
                ++n3;
            }
        } else if (VariableRangeExpression.class.isAssignableFrom(base.getClass())) {
            VariableRangeExpression expr = (VariableRangeExpression)base;
            Range range = new Range();
            if (expr.getFirst() != null) {
                range.setStart(expr.getFirst());
            }
            if (expr.getLast() != null) {
                range.setEnd(expr.getLast());
            }
            value.setSourceVariableRange(range);
        }
        return value;
    }

    default public String checkConstantExpressions(ExpressionBase expression) {
        String value = null;
        if (NumericConstantExpression.class.isAssignableFrom(expression.getClass())) {
            NumericConstantExpression nce = (NumericConstantExpression)expression;
            value = nce.getValue();
        } else if (StringConstantExpression.class.isAssignableFrom(expression.getClass())) {
            StringConstantExpression sce = (StringConstantExpression)expression;
            value = sce.getValue();
        } else if (NumericMaximumValueExpression.class.isAssignableFrom(expression.getClass())) {
            value = MinMax.MAXIMUM.getValue();
        } else if (NumericMinimumValueExpression.class.isAssignableFrom(expression.getClass())) {
            value = MinMax.MINIMUM.getValue();
        }
        return value;
    }

    default public void checkForNestedExpressions(ExpressionBase expression, NewVariable newVariable) {
        if (VariableSymbolExpression.class.isAssignableFrom(expression.getClass())) {
            VariableSymbolExpression expr = (VariableSymbolExpression)expression;
            newVariable.addSourceVariables(expr.getVariableName());
            newVariable.setBasisVariableName(expr.getVariableName());
        } else if (VariableRangeExpression.class.isAssignableFrom(expression.getClass())) {
            VariableRangeExpression expr = (VariableRangeExpression)expression;
            newVariable.addSourceVariables(expr.getFirst(), expr.getLast());
            Range range = new Range();
            range.setStart(expr.getFirst());
            range.setEnd(expr.getLast());
            newVariable.setSourceVariableRange(range);
        } else if (VariableListExpression.class.isAssignableFrom(expression.getClass())) {
            VariableListExpression expr = (VariableListExpression)expression;
            VariableReferenceBase[] variableReferenceBaseArray = expr.getVariables();
            int n = variableReferenceBaseArray.length;
            int n2 = 0;
            while (n2 < n) {
                VariableReferenceBase range = variableReferenceBaseArray[n2];
                ++n2;
            }
        } else if (FunctionCallExpression.class.isAssignableFrom(expression.getClass())) {
            FunctionCallExpression expr = (FunctionCallExpression)expression;
            FunctionArgument[] functionArgumentArray = expr.getArguments();
            int n = functionArgumentArray.length;
            int n3 = 0;
            while (n3 < n) {
                FunctionArgument eb = functionArgumentArray[n3];
                this.checkForNestedExpressions(eb.getArgumentValue(), newVariable);
                ++n3;
            }
        } else if (GroupedExpression.class.isAssignableFrom(expression.getClass())) {
            GroupedExpression expr = (GroupedExpression)expression;
            this.checkForNestedExpressions(expr.getExpression(), newVariable);
        } else if (NumericConstantExpression.class.isAssignableFrom(expression.getClass())) {
            NumericConstantExpression expr = (NumericConstantExpression)expression;
            newVariable.setDataType(expr.getNumericType());
            newVariable.addPossibleCodes(String.valueOf(expr.getValue()));
        } else if (MissingValueConstantExpression.class.isAssignableFrom(expression.getClass())) {
            MissingValueConstantExpression expr = (MissingValueConstantExpression)expression;
            newVariable.setDataType(expr.getTypeName());
            newVariable.addPossibleCodes(String.valueOf(expr.getValue()));
        } else if (StringConstantExpression.class.isAssignableFrom(expression.getClass())) {
            StringConstantExpression expr = (StringConstantExpression)expression;
            newVariable.setDataType(expr.getType());
            newVariable.addPossibleCodes(expr.getValue());
        }
    }

    default public Set<String> parseTransformBase(TransformBase base) {
        HashSet<String> vars = new HashSet<String>();
        if (org.c2metadata.sdtl.pojo.command.Compute.class.isAssignableFrom(base.getClass())) {
            org.c2metadata.sdtl.pojo.command.Compute compute = (org.c2metadata.sdtl.pojo.command.Compute)base;
            SdtlWrapper wrapper = WrapperFactory.wrap((CommandBase)compute);
            Compute computeWrapper = (Compute)wrapper;
            vars.addAll(computeWrapper.getVariables());
        }
        return vars;
    }

    default public List<Range> getRangesFromTransformBase(TransformBase base) {
        ArrayList<Range> ranges = new ArrayList<Range>();
        if (org.c2metadata.sdtl.pojo.command.Compute.class.isAssignableFrom(base.getClass())) {
            org.c2metadata.sdtl.pojo.command.Compute compute = (org.c2metadata.sdtl.pojo.command.Compute)base;
            SdtlWrapper wrapper = WrapperFactory.wrap((CommandBase)compute);
            Compute computeWrapper = (Compute)wrapper;
            ranges.addAll(computeWrapper.getRanges());
        }
        return ranges;
    }

    default public Set<String> getVariablesFromVariableReferenceBase(VariableReferenceBase base) {
        VariableSymbolExpression se;
        HashSet<String> vars = new HashSet<String>();
        if (base != null && VariableSymbolExpression.class.isAssignableFrom(base.getClass()) && (se = (VariableSymbolExpression)base).getVariableName() != null) {
            String name = se.getVariableName();
            vars.add(name);
        }
        return vars;
    }

    default public Set<String> getVariablesFromVariableReferenceBaseTEST(VariableReferenceBase base) {
        HashSet<String> vars = new HashSet<String>();
        if (VariableSymbolExpression.class.isAssignableFrom(base.getClass())) {
            VariableSymbolExpression se = (VariableSymbolExpression)base;
            if (se.getVariableName() != null) {
                String name = se.getVariableName();
                vars.add(name);
            }
        } else if (VariableListExpression.class.isAssignableFrom(base.getClass())) {
            VariableListExpression se = (VariableListExpression)base;
            VariableReferenceBase[] variableReferenceBaseArray = se.getVariables();
            int n = variableReferenceBaseArray.length;
            int n2 = 0;
            while (n2 < n) {
                VariableReferenceBase inner = variableReferenceBaseArray[n2];
                vars.addAll(this.getVariablesFromVariableReferenceBase(inner));
                ++n2;
            }
        } else if (AllVariablesExpression.class.isAssignableFrom(base.getClass())) {
            AllVariablesExpression allVariablesExpression = (AllVariablesExpression)base;
        }
        return vars;
    }

    default public Set<String> getVariablesFromVariableReferenceBaseArray(VariableReferenceBase ... array) {
        HashSet<String> vars = new HashSet<String>();
        if (array != null && array.length > 0) {
            VariableReferenceBase[] variableReferenceBaseArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                VariableReferenceBase var = variableReferenceBaseArray[n2];
                vars.addAll(this.getVariablesFromVariableReferenceBase(var));
                ++n2;
            }
        }
        return vars;
    }

    default public List<Range> getRangesFromVariableReferenceBase(VariableReferenceBase base) {
        ArrayList<Range> ranges = new ArrayList<Range>();
        if (base != null && VariableRangeExpression.class.isAssignableFrom(base.getClass())) {
            VariableRangeExpression se = (VariableRangeExpression)base;
            Range range = new Range();
            if (se.getFirst() != null) {
                range.setStart(se.getFirst());
            }
            if (se.getLast() != null) {
                range.setEnd(se.getLast());
            }
            ranges.add(range);
        }
        return ranges;
    }

    default public List<Range> getRangesFromVariableReferenceBaseArray(VariableReferenceBase[] array) {
        ArrayList<Range> ranges = new ArrayList<Range>();
        if (array != null) {
            VariableReferenceBase[] variableReferenceBaseArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                VariableReferenceBase base = variableReferenceBaseArray[n2];
                ranges.addAll(this.getRangesFromVariableReferenceBase(base));
                ++n2;
            }
        }
        return ranges;
    }
}

