/*
 * Decompiled with CFR 0.152.
 */
package us.mtna.data.transform.wrapper.sdtl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.c2metadata.sdtl.pojo.RenamePair;
import org.c2metadata.sdtl.pojo.command.TransformBase;
import org.c2metadata.sdtl.pojo.expression.VariableSymbolExpression;
import us.mtna.data.transform.command.SelectsVariables;
import us.mtna.data.transform.command.UpdatesVariables;
import us.mtna.data.transform.command.object.Range;
import us.mtna.data.transform.command.object.VariableNamePair;
import us.mtna.data.transform.wrapper.sdtl.ValidationResult;
import us.mtna.pojo.DataType;

public class Rename
implements SelectsVariables,
UpdatesVariables {
    private org.c2metadata.sdtl.pojo.command.Rename sdtl;

    public Rename(org.c2metadata.sdtl.pojo.command.Rename sdtl) {
        this.sdtl = sdtl;
    }

    @Override
    public ValidationResult validate() {
        ValidationResult result = new ValidationResult();
        if (this.sdtl.getRenames() == null || this.sdtl.getRenames().length < 1) {
            result.setValid(false);
            result.addMessages("No RenamePairs found in the SDTL when trying to execute command [" + this.sdtl.getCommand() + "] ");
        }
        return result;
    }

    @Override
    public TransformBase getOriginalCommand() {
        return this.sdtl;
    }

    @Override
    public List<Range> getRanges() {
        return new ArrayList<Range>();
    }

    @Override
    public Set<String> getVariables() {
        HashSet<String> vars = new HashSet<String>();
        if (this.sdtl.getRenames() != null) {
            RenamePair[] renamePairArray = this.sdtl.getRenames();
            int n = renamePairArray.length;
            int n2 = 0;
            while (n2 < n) {
                RenamePair rp = renamePairArray[n2];
                VariableSymbolExpression vse = rp.getOldVariable();
                vars.add(vse.getVariableName());
                ++n2;
            }
        }
        return vars;
    }

    @Override
    public VariableNamePair[] getUpdatedVariables() {
        ArrayList<VariableNamePair> pairs = new ArrayList<VariableNamePair>();
        if (this.sdtl.getRenames() != null) {
            RenamePair[] renamePairArray = this.sdtl.getRenames();
            int n = renamePairArray.length;
            int n2 = 0;
            while (n2 < n) {
                RenamePair rp = renamePairArray[n2];
                VariableSymbolExpression newVar = rp.getNewVariable();
                VariableSymbolExpression oldVar = rp.getOldVariable();
                VariableNamePair pair = new VariableNamePair(oldVar.getVariableName(), newVar.getVariableName());
                pairs.add(pair);
                ++n2;
            }
        }
        VariableNamePair[] arr = new VariableNamePair[pairs.size()];
        arr = pairs.toArray(arr);
        return arr;
    }

    @Override
    public DataType getDataType() {
        return null;
    }
}

