/*
 * Decompiled with CFR 0.152.
 */
package us.mtna.data.transform.wrapper.sdtl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.c2metadata.sdtl.pojo.MergeFileDescription;
import org.c2metadata.sdtl.pojo.RenamePair;
import org.c2metadata.sdtl.pojo.command.TransformBase;
import org.c2metadata.sdtl.pojo.expression.VariableSymbolExpression;
import us.mtna.data.transform.command.CreatesVariables;
import us.mtna.data.transform.command.DeletesVariable;
import us.mtna.data.transform.command.SelectsVariables;
import us.mtna.data.transform.command.UpdatesVariables;
import us.mtna.data.transform.command.ds.MergesDatasets;
import us.mtna.data.transform.command.ds.UpdatesCases;
import us.mtna.data.transform.command.object.NewVariable;
import us.mtna.data.transform.command.object.Range;
import us.mtna.data.transform.command.object.UpdaterMergeFileDescription;
import us.mtna.data.transform.command.object.VariableNamePair;
import us.mtna.data.transform.wrapper.sdtl.ValidationResult;
import us.mtna.pojo.DataType;

public class MergeDatasets
implements MergesDatasets,
CreatesVariables,
DeletesVariable,
UpdatesVariables,
UpdatesCases,
SelectsVariables {
    private org.c2metadata.sdtl.pojo.command.MergeDatasets sdtl;

    public MergeDatasets(org.c2metadata.sdtl.pojo.command.MergeDatasets sdtl) {
        this.sdtl = sdtl;
    }

    @Override
    public ValidationResult validate() {
        ValidationResult result = new ValidationResult();
        if (this.sdtl.getMergeFiles() == null || this.sdtl.getMergeFiles().length < 2) {
            result.setValid(false);
            result.addMessages("MergeDatasets command must have at least two MergeFileDescriptions. Command: [" + this.sdtl.getCommand() + "]");
        } else {
            int i = 0;
            MergeFileDescription[] mergeFileDescriptionArray = this.sdtl.getMergeFiles();
            int n = mergeFileDescriptionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Enum type;
                int n3;
                int n4;
                Enum[] enumArray;
                StringBuilder sb;
                MergeFileDescription desc = mergeFileDescriptionArray[n2];
                if (desc.getFileName() == null) {
                    result.setValid(false);
                    result.addMessages("No file name found on the merge file description at index [" + i + "] in command [" + this.sdtl.getCommand() + "]");
                }
                if (desc.getMergeType() == null) {
                    result.setValid(false);
                    result.addMessages("No merge type found on the merge file description at index [" + i + "] in command [" + this.sdtl.getCommand() + "]");
                } else if (this.parseMergeType(desc.getMergeType()) == null) {
                    result.setValid(false);
                    sb = new StringBuilder();
                    enumArray = UpdaterMergeFileDescription.MergeType.values();
                    n4 = enumArray.length;
                    n3 = 0;
                    while (n3 < n4) {
                        type = enumArray[n3];
                        sb.append(type.toString()).append(" ");
                        ++n3;
                    }
                    result.addMessages("The mergeType [" + desc.getMergeType() + "] on the merge file description at index [" + i + "] in command [" + this.sdtl.getCommand() + "] did not match one of the expected values: [" + sb.toString() + "]");
                }
                if (desc.getUpdate() == null) {
                    result.setValid(false);
                    result.addMessages("No update string found on the merge file description at index [" + i + "] in command [" + this.sdtl.getCommand() + "]");
                } else if (this.parseUpdateType(desc.getUpdate()) == null) {
                    result.setValid(false);
                    sb = new StringBuilder();
                    enumArray = UpdaterMergeFileDescription.UpdateType.values();
                    n4 = enumArray.length;
                    n3 = 0;
                    while (n3 < n4) {
                        type = enumArray[n3];
                        sb.append(type.toString()).append(" ");
                        ++n3;
                    }
                    result.addMessages("The update type [" + desc.getUpdate() + "] on the merge file description at index [" + i + "] in command [" + this.sdtl.getCommand() + "] did not match one of the expected values: [" + sb.toString() + "]");
                }
                ++i;
                ++n2;
            }
        }
        return result;
    }

    @Override
    public TransformBase getOriginalCommand() {
        return this.sdtl;
    }

    @Override
    public Set<String> getMergeByVariables() {
        return this.getVariablesFromVariableReferenceBaseArray(this.sdtl.getMergeByVariables());
    }

    @Override
    public Set<String> getKeepVariables() {
        HashSet<String> keeps = new HashSet<String>();
        MergeFileDescription[] mergeFileDescriptionArray = this.sdtl.getMergeFiles();
        int n = mergeFileDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            MergeFileDescription desc = mergeFileDescriptionArray[n2];
            keeps.addAll(this.getVariablesFromVariableReferenceBaseArray(desc.getKeepVariables()));
            ++n2;
        }
        return keeps;
    }

    @Override
    public List<UpdaterMergeFileDescription> getMergeFileDscr() {
        ArrayList<UpdaterMergeFileDescription> list = new ArrayList<UpdaterMergeFileDescription>();
        MergeFileDescription[] mergeFileDescriptionArray = this.sdtl.getMergeFiles();
        int n = mergeFileDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            MergeFileDescription dscr = mergeFileDescriptionArray[n2];
            UpdaterMergeFileDescription file = new UpdaterMergeFileDescription();
            file.setDropVariables(dscr.getDropVariables());
            file.setFileName(dscr.getFileName());
            file.setKeepVariables(dscr.getKeepVariables());
            file.setMergeFlagVariable(dscr.getMergeFlagVariable());
            file.setMergeType(this.parseMergeType(dscr.getMergeType()));
            file.setNewRow(dscr.isNewRow());
            file.setUpdate(this.parseUpdateType(dscr.getUpdate()));
            file.setRenameVariables(this.getVarNamePairsFromRenamePairs(dscr.getRenameVariables()));
            list.add(file);
            ++n2;
        }
        return list;
    }

    public UpdaterMergeFileDescription.MergeType parseMergeType(String text) {
        switch (text.toUpperCase().trim()) {
            case "SEQUENTIAL": {
                return UpdaterMergeFileDescription.MergeType.SEQUENTIAL;
            }
            case "ONETOONE": {
                return UpdaterMergeFileDescription.MergeType.ONE_TO_ONE;
            }
            case "MANYTOONE": {
                return UpdaterMergeFileDescription.MergeType.MANY_TO_ONE;
            }
            case "ONETOMANY": {
                return UpdaterMergeFileDescription.MergeType.ONE_TO_MANY;
            }
            case "CARTESIAN": {
                return UpdaterMergeFileDescription.MergeType.CARTESIAN;
            }
            case "UNMATCHED": {
                return UpdaterMergeFileDescription.MergeType.UNMATCHED;
            }
            case "SASMATCHMERGE": {
                return UpdaterMergeFileDescription.MergeType.SAS_MATCH_MERGE;
            }
        }
        return null;
    }

    public UpdaterMergeFileDescription.UpdateType parseUpdateType(String text) {
        switch (text.toUpperCase().trim()) {
            case "MASTER": {
                return UpdaterMergeFileDescription.UpdateType.MASTER;
            }
            case "IGNORE": {
                return UpdaterMergeFileDescription.UpdateType.IGNORE;
            }
            case "FILLNEW": {
                return UpdaterMergeFileDescription.UpdateType.FILL_NEW;
            }
            case "UPDATEMISSING": {
                return UpdaterMergeFileDescription.UpdateType.UPDATE_MISSING;
            }
            case "REPLACE": {
                return UpdaterMergeFileDescription.UpdateType.REPLACE;
            }
        }
        return null;
    }

    private List<VariableNamePair> getVarNamePairsFromRenamePairs(RenamePair[] pairs) {
        ArrayList<VariableNamePair> list = new ArrayList<VariableNamePair>();
        if (pairs != null) {
            RenamePair[] renamePairArray = pairs;
            int n = pairs.length;
            int n2 = 0;
            while (n2 < n) {
                RenamePair pair = renamePairArray[n2];
                if (pair.getNewVariable() != null && pair.getOldVariable() != null && pair.getNewVariable().getVariableName() != null && pair.getOldVariable().getVariableName() != null) {
                    list.add(new VariableNamePair(pair.getOldVariable().getVariableName(), pair.getNewVariable().getVariableName()));
                }
                ++n2;
            }
        }
        return list;
    }

    @Override
    public String getFirstVariable() {
        return this.sdtl.getFirstVariable();
    }

    @Override
    public String getLastVariable() {
        return this.sdtl.getLastVariable();
    }

    @Override
    public NewVariable[] getNewVariables() {
        ArrayList<NewVariable> newVars = new ArrayList<NewVariable>();
        if (this.sdtl.getFirstVariable() != null) {
            NewVariable first = new NewVariable();
            first.setNewVariableName(this.sdtl.getFirstVariable());
            newVars.add(first);
        }
        if (this.sdtl.getLastVariable() != null) {
            NewVariable last = new NewVariable();
            last.setNewVariableName(this.sdtl.getLastVariable());
            newVars.add(last);
        }
        return newVars.toArray(new NewVariable[0]);
    }

    @Override
    public Set<String> getDeletedVars() {
        HashSet<String> drops = new HashSet<String>();
        MergeFileDescription[] mergeFileDescriptionArray = this.sdtl.getMergeFiles();
        int n = mergeFileDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            MergeFileDescription desc = mergeFileDescriptionArray[n2];
            drops.addAll(this.getVariablesFromVariableReferenceBaseArray(desc.getDropVariables()));
            ++n2;
        }
        return drops;
    }

    @Override
    public List<Range> getDeletedVariableRanges() {
        ArrayList<Range> drops = new ArrayList<Range>();
        MergeFileDescription[] mergeFileDescriptionArray = this.sdtl.getMergeFiles();
        int n = mergeFileDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            MergeFileDescription desc = mergeFileDescriptionArray[n2];
            drops.addAll(this.getRangesFromVariableReferenceBaseArray(desc.getDropVariables()));
            ++n2;
        }
        return drops;
    }

    @Override
    public Set<String> getKeepVars() {
        HashSet<String> kept = new HashSet<String>();
        MergeFileDescription[] mergeFileDescriptionArray = this.sdtl.getMergeFiles();
        int n = mergeFileDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            MergeFileDescription file = mergeFileDescriptionArray[n2];
            kept.addAll(this.getVariablesFromVariableReferenceBaseArray(file.getKeepVariables()));
            ++n2;
        }
        return kept;
    }

    @Override
    public List<Range> getKeepVariableRanges() {
        ArrayList<Range> kept = new ArrayList<Range>();
        MergeFileDescription[] mergeFileDescriptionArray = this.sdtl.getMergeFiles();
        int n = mergeFileDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            MergeFileDescription file = mergeFileDescriptionArray[n2];
            kept.addAll(this.getRangesFromVariableReferenceBaseArray(file.getKeepVariables()));
            ++n2;
        }
        return kept;
    }

    @Override
    public List<Range> getRanges() {
        ArrayList<Range> allRanges = new ArrayList<Range>();
        allRanges.addAll(this.getKeepVariableRanges());
        allRanges.addAll(this.getDeletedVariableRanges());
        return allRanges;
    }

    @Override
    public Set<String> getVariables() {
        HashSet<String> allVariables = new HashSet<String>();
        allVariables.addAll(this.getKeepVars());
        allVariables.addAll(this.getDeletedVars());
        if (this.sdtl.getFirstVariable() != null) {
            allVariables.add(this.sdtl.getFirstVariable());
        }
        if (this.sdtl.getLastVariable() != null) {
            allVariables.add(this.sdtl.getLastVariable());
        }
        VariableNamePair[] variableNamePairArray = this.getUpdatedVariables();
        int n = variableNamePairArray.length;
        int n2 = 0;
        while (n2 < n) {
            VariableNamePair pair = variableNamePairArray[n2];
            allVariables.add(pair.getSource());
            ++n2;
        }
        return allVariables;
    }

    @Override
    public VariableNamePair[] getUpdatedVariables() {
        ArrayList<VariableNamePair> pairs = new ArrayList<VariableNamePair>();
        MergeFileDescription[] mergeFileDescriptionArray = this.sdtl.getMergeFiles();
        int n = mergeFileDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            MergeFileDescription file = mergeFileDescriptionArray[n2];
            if (file.getRenameVariables() != null) {
                RenamePair[] renamePairArray = file.getRenameVariables();
                int n3 = renamePairArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    RenamePair rp = renamePairArray[n4];
                    VariableSymbolExpression newVar = rp.getNewVariable();
                    VariableSymbolExpression oldVar = rp.getOldVariable();
                    VariableNamePair pair = new VariableNamePair(oldVar.getVariableName(), newVar.getVariableName());
                    pairs.add(pair);
                    ++n4;
                }
            }
            ++n2;
        }
        VariableNamePair[] pairArray = new VariableNamePair[pairs.size()];
        return pairs.toArray(pairArray);
    }

    @Override
    public DataType getDataType() {
        return null;
    }
}

