/*
 * Decompiled with CFR 0.152.
 */
package us.mtna.dataset.updater.info.ws;

import com.fasterxml.jackson.databind.JsonMappingException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.context.annotation.Bean;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;
import us.mtna.dataset.updater.exception.C2MError;
import us.mtna.dataset.updater.exception.InvalidSdtlException;
import us.mtna.dataset.updater.exception.TransformationException;
import us.mtna.dataset.updater.exception.UpdaterException;
import us.mtna.dataset.updater.info.ws.DatasetInformationManager;
import us.mtna.dataset.updater.info.ws.DatasetInformationManagerImpl;
import us.mtna.pojo.DataSet;
import us.mtna.pojo.Variable;
import us.mtna.reader.exceptions.BaseC2MException;
import us.mtna.reader.exceptions.ReaderException;
import us.mtna.reader.exceptions.RequestException;
import us.mtna.reader.exceptions.XmlValidationException;

@RestController
@RequestMapping(value={"/api/info/"})
public class DatasetInformationController {
    private DatasetInformationManager manager = new DatasetInformationManagerImpl();

    @RequestMapping(value={"variables"}, method={RequestMethod.POST}, consumes={"multipart/form-data"})
    public List<Variable> getVariables(@RequestHeader HttpHeaders headers, @RequestPart(value="file", required=true) MultipartFile file) {
        return this.manager.getVariables(file);
    }

    @RequestMapping(value={"variables/names"}, method={RequestMethod.POST}, consumes={"multipart/form-data"})
    public List<String> getVariableNames(@RequestHeader HttpHeaders headers, @RequestPart(value="file", required=true) MultipartFile file) {
        return this.manager.getVariableNames(file);
    }

    @RequestMapping(value={"variables/ids"}, method={RequestMethod.POST}, consumes={"multipart/form-data"})
    public List<String> getVariableIds(@RequestHeader HttpHeaders headers, @RequestPart(value="file", required=true) MultipartFile file) {
        return this.manager.getVariableIds(file);
    }

    @RequestMapping(value={"datasets"}, method={RequestMethod.POST}, consumes={"multipart/form-data"})
    public List<DataSet> getDatasets(@RequestHeader HttpHeaders headers, @RequestPart(value="file", required=true) MultipartFile file) {
        return this.manager.getDataSets(file);
    }

    @Bean(name={"multipartResolver"})
    public CommonsMultipartResolver multipartResolver() {
        CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver();
        return multipartResolver;
    }

    @ExceptionHandler(value={TransformationException.class})
    public ResponseEntity<C2MError> handleTransformationException(HttpServletRequest req, TransformationException exception) {
        HttpStatus status = HttpStatus.BAD_REQUEST;
        if (exception instanceof InvalidSdtlException) {
            InvalidSdtlException e = (InvalidSdtlException)exception;
            return this.getErrorResponse(req, status, (Exception)((Object)exception), e.getMessages());
        }
        return this.getErrorResponse(req, status, (Exception)((Object)exception));
    }

    @ExceptionHandler(value={RequestException.class})
    public ResponseEntity<C2MError> handleRequestException(HttpServletRequest req, RequestException exception) {
        HttpStatus status = HttpStatus.BAD_REQUEST;
        if (exception instanceof XmlValidationException) {
            XmlValidationException e = (XmlValidationException)exception;
            return this.getErrorResponse(req, status, (Exception)exception, e.getErrorMessages());
        }
        return this.getErrorResponse(req, status, (Exception)exception);
    }

    @ExceptionHandler(value={ReaderException.class})
    public ResponseEntity<C2MError> handleReaderException(HttpServletRequest req, ReaderException exception) {
        HttpStatus status = HttpStatus.BAD_REQUEST;
        return this.getErrorResponse(req, status, (Exception)exception);
    }

    @ExceptionHandler(value={BaseC2MException.class})
    public ResponseEntity<C2MError> handleBaseException(HttpServletRequest req, BaseC2MException exception) {
        HttpStatus status = HttpStatus.BAD_REQUEST;
        return this.getErrorResponse(req, status, (Exception)exception);
    }

    @ExceptionHandler(value={UpdaterException.class})
    public ResponseEntity<C2MError> handleUpdaterException(HttpServletRequest req, UpdaterException exception) {
        HttpStatus status = HttpStatus.INTERNAL_SERVER_ERROR;
        return this.getErrorResponse(req, status, (Exception)((Object)exception));
    }

    @ExceptionHandler(value={JsonMappingException.class})
    public ResponseEntity<C2MError> handleJsonMappingException(HttpServletRequest req, JsonMappingException exception) {
        HttpStatus status = HttpStatus.BAD_REQUEST;
        System.out.println(req.getRequestURI());
        if (exception instanceof JsonMappingException) {
            ArrayList<String> messages = new ArrayList<String>();
            messages.add("Invalid SDTL detected.");
            messages.add(exception.getMessage());
            InvalidSdtlException sdtlException = new InvalidSdtlException(messages);
            return this.getErrorResponse(req, HttpStatus.OK, (Exception)((Object)sdtlException));
        }
        return this.getErrorResponse(req, status, (Exception)exception);
    }

    private ResponseEntity<C2MError> getErrorResponse(HttpServletRequest req, HttpStatus status, Exception exception) {
        C2MError message = new C2MError(exception);
        message.setCode(status.value());
        return new ResponseEntity((Object)message, status);
    }

    private ResponseEntity<C2MError> getErrorResponse(HttpServletRequest req, HttpStatus status, Exception exception, List<String> messages) {
        C2MError message = new C2MError(messages);
        message.setCode(status.value());
        return new ResponseEntity((Object)message, status);
    }
}

