/*
 * Decompiled with CFR 0.152.
 */
package us.mtna.dataset.updater;

import java.util.ArrayList;
import java.util.List;
import org.c2metadata.sdtl.pojo.Message;
import org.c2metadata.sdtl.pojo.Program;
import org.c2metadata.sdtl.pojo.command.CommandBase;
import us.mtna.data.transform.command.SdtlWrapper;
import us.mtna.data.transform.wrapper.sdtl.ValidationResult;
import us.mtna.data.transform.wrapper.sdtl.WrapperFactory;

public class ValidationUtility {
    public static ValidationResult validate(Program sdtlProgram) {
        ValidationResult returned = new ValidationResult();
        boolean valid = true;
        ArrayList messages = new ArrayList();
        for (CommandBase base : sdtlProgram.getCommands()) {
            SdtlWrapper wrapper = WrapperFactory.wrap((CommandBase)base);
            ValidationResult result = wrapper.validate();
            if (result.isValid()) continue;
            valid = false;
            messages.addAll(result.getMessages());
        }
        returned.setValid(valid);
        returned.setMessages(messages);
        return returned;
    }

    public static List<Message> getValidationMessages(Program sdtlProgram) {
        ArrayList<Message> messages = new ArrayList<Message>();
        for (CommandBase base : sdtlProgram.getCommands()) {
            SdtlWrapper wrapper = WrapperFactory.wrap((CommandBase)base);
            ValidationResult result = wrapper.validate();
            if (result.isValid()) continue;
            for (String s : result.getMessages()) {
                Message message = new Message();
                message.setSeverity("Error");
                message.setMessageText(new String[]{s});
                messages.add(message);
            }
        }
        return messages;
    }
}

