/*
 * Decompiled with CFR 0.152.
 */
package us.mtna.dataset.updater;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.ddialliance.ddi_2_5.xml.xmlbeans.CitationType;
import org.ddialliance.ddi_2_5.xml.xmlbeans.CodeBookDocument;
import org.ddialliance.ddi_2_5.xml.xmlbeans.CodeBookType;
import org.ddialliance.ddi_2_5.xml.xmlbeans.MaterialReferenceType;
import org.ddialliance.ddi_2_5.xml.xmlbeans.OthrStdyMatType;
import org.ddialliance.ddi_2_5.xml.xmlbeans.ProdStmtType;
import org.ddialliance.ddi_2_5.xml.xmlbeans.RspStmtType;
import org.ddialliance.ddi_2_5.xml.xmlbeans.StdyDscrType;
import org.ddialliance.ddi_2_5.xml.xmlbeans.TitlStmtType;
import org.ddialliance.ddi_2_5.xml.xmlbeans.VerStmtType;
import org.openmetadata.util.xmlbeans.XhtmlUtilities;
import org.openmetadata.util.xmlbeans.XmlIdRandomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.mtna.dataset.updater.exception.MergeException;
import us.mtna.updater.DatasetMetadata;

public class DdiManager {
    private String author;
    private String title;
    private String date;
    private String id;
    private static final String VERSION = "V1";
    private static final String NOTE = "Data from this study were used in the transformations described in this DDI Instance ";
    private static final String DEFAULT_TITLE = "Generated with the C2Metadata Dataset Updater Service.";
    private static Logger log = LoggerFactory.getLogger(DdiManager.class);
    private DatasetMetadata metadata;

    public DdiManager(String author, String title, String date, String id) {
        this.author = author;
        this.title = title;
        this.date = date;
        this.id = id;
    }

    public DdiManager(DatasetMetadata metadata) {
        this.metadata = metadata;
    }

    public DdiManager() {
    }

    public CodeBookDocument merge(InputStream ... inputStreams) throws MergeException {
        ArrayList<CodeBookDocument> cbDocuments = new ArrayList<CodeBookDocument>();
        InputStream[] inputStreamArray = inputStreams;
        int n = inputStreams.length;
        int n2 = 0;
        while (n2 < n) {
            CodeBookDocument codeBook;
            InputStream input = inputStreamArray[n2];
            try {
                codeBook = CodeBookDocument.Factory.parse((InputStream)input);
            }
            catch (IOException | XmlException e) {
                log.error("An error occured reading the streams to merge");
                throw new MergeException("An error occured reading the streams to merge", e);
            }
            cbDocuments.add(codeBook);
            ++n2;
        }
        return this.merge(cbDocuments);
    }

    public CodeBookDocument merge(XmlObject ... inputStreams) throws MergeException {
        ArrayList<CodeBookDocument> cbDocuments = new ArrayList<CodeBookDocument>();
        XmlObject[] xmlObjectArray = inputStreams;
        int n = inputStreams.length;
        int n2 = 0;
        while (n2 < n) {
            XmlObject input = xmlObjectArray[n2];
            cbDocuments.add((CodeBookDocument)input);
            ++n2;
        }
        return this.merge(cbDocuments);
    }

    public CodeBookDocument merge(File ... files) throws MergeException {
        ArrayList<CodeBookDocument> cbDocuments = new ArrayList<CodeBookDocument>();
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            CodeBookDocument codeBook;
            File file = fileArray[n2];
            try {
                codeBook = CodeBookDocument.Factory.parse((File)file);
            }
            catch (IOException | XmlException e) {
                log.error("An error occured reading the files to merge", e);
                throw new MergeException("An error occured reading the files to merge", e);
            }
            cbDocuments.add(codeBook);
            ++n2;
        }
        return this.merge(cbDocuments);
    }

    private CodeBookDocument merge(Collection<CodeBookDocument> documents) {
        try {
            HashSet ids = new HashSet();
            CodeBookDocument mergedCodeDoc = CodeBookDocument.Factory.newInstance();
            CodeBookType cbt = mergedCodeDoc.addNewCodeBook();
            cbt.setID("MERGED_DDI");
            for (CodeBookDocument cb : documents) {
                log.info("merging codebook [" + cb.getCodeBook().getID() + "] into the merged document");
                XmlIdRandomizer.randomizeIds((XmlObject)cb, ids);
                this.copyElementsIntoNewDoc(cb, mergedCodeDoc);
            }
            this.addCitations(documents, mergedCodeDoc);
            return mergedCodeDoc;
        }
        catch (RuntimeException e) {
            log.error("Merge exception when trying to merge codebooks into a single document");
            throw new MergeException(e);
        }
    }

    private void addCitations(Collection<CodeBookDocument> documents, CodeBookDocument newDoc) {
        StdyDscrType newDocStdy = (StdyDscrType)newDoc.getCodeBook().getStdyDscrList().get(0);
        OthrStdyMatType other = newDocStdy.addNewOthrStdyMat();
        for (CodeBookDocument cbd : documents) {
            ArrayList<CitationType> citations = new ArrayList<CitationType>();
            MaterialReferenceType relStdy = other.addNewRelStdy();
            for (StdyDscrType sdt : cbd.getCodeBook().getStdyDscrList()) {
                for (CitationType citation : sdt.getCitationList()) {
                    citations.add(citation);
                }
                relStdy.setCitationArray(citations.toArray(new CitationType[0]));
            }
        }
        CitationType citation = newDocStdy.addNewCitation();
        TitlStmtType titleType = citation.addNewTitlStmt();
        if (this.title == null || this.title.isEmpty()) {
            this.title = DEFAULT_TITLE;
        }
        XhtmlUtilities.setXhtmlContent((XmlObject)titleType.addNewTitl(), (String)this.title);
        if (this.id != null && !this.id.isEmpty()) {
            XhtmlUtilities.setXhtmlContent((XmlObject)titleType.addNewIDNo(), (String)this.id);
        }
        RspStmtType rsp = citation.addNewRspStmt();
        ProdStmtType prod = citation.addNewProdStmt();
        if (this.author != null && !this.author.isEmpty()) {
            XhtmlUtilities.setXhtmlContent((XmlObject)rsp.addNewAuthEnty(), (String)this.author);
            XhtmlUtilities.setXhtmlContent((XmlObject)prod.addNewProducer(), (String)this.author);
        }
        if (this.date != null && !this.date.isEmpty()) {
            XhtmlUtilities.setXhtmlContent((XmlObject)prod.addNewProdDate(), (String)this.date);
        }
        VerStmtType ver = citation.addNewVerStmt();
        if (VERSION != null && !VERSION.isEmpty()) {
            XhtmlUtilities.setXhtmlContent((XmlObject)ver.addNewVersion(), (String)VERSION);
        }
        if (NOTE != null && !NOTE.isEmpty()) {
            XhtmlUtilities.setXhtmlContent((XmlObject)ver.addNewNotes(), (String)NOTE);
        }
    }

    public CodeBookDocument createNewDocument(CodeBookDocument originalCodeBook) {
        CodeBookDocument newDocument = CodeBookDocument.Factory.newInstance();
        newDocument.addNewCodeBook();
        this.copyElementsIntoNewDoc(originalCodeBook, newDocument);
        return newDocument;
    }

    private void copyElementsIntoNewDoc(CodeBookDocument originalCodeBook, CodeBookDocument newCodeDoc) {
        StdyDscrType newStdy;
        CodeBookType cbType = originalCodeBook.getCodeBook();
        CodeBookType mergedCD = newCodeDoc.getCodeBook();
        for (StdyDscrType sd : cbType.getStdyDscrList()) {
            newStdy = mergedCD.addNewStdyDscr();
            newStdy.set((XmlObject)sd);
        }
        for (StdyDscrType sd : cbType.getDocDscrList()) {
            newStdy = mergedCD.addNewDocDscr();
            newStdy.set((XmlObject)sd);
        }
        for (StdyDscrType sd : cbType.getDataDscrList()) {
            newStdy = mergedCD.addNewDataDscr();
            newStdy.set((XmlObject)sd);
        }
        for (StdyDscrType sd : cbType.getFileDscrList()) {
            newStdy = mergedCD.addNewFileDscr();
            newStdy.set((XmlObject)sd);
        }
        for (StdyDscrType sd : cbType.getOtherMatList()) {
            newStdy = mergedCD.addNewOtherMat();
            newStdy.set((XmlObject)sd);
        }
    }

    public static Logger getLog() {
        return log;
    }

    public static void setLog(Logger log) {
        DdiManager.log = log;
    }
}

