/*
 * Decompiled with CFR 0.152.
 */
package us.mtna.dataset.updater;

import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.impl.values.XmlAnyTypeImpl;
import org.ddialliance.ddi_2_5.xml.xmlbeans.CodeBookDocument;
import org.ecoinformatics.eml_2_1_1.xml.xmlbeans.EmlDocument;
import org.springframework.web.multipart.MultipartFile;
import us.mtna.c2metadata.xml.Ddi25XmlUpdater;
import us.mtna.c2metadata.xml.EmlUpdater;
import us.mtna.c2metadata.xml.XmlUpdater;
import us.mtna.reader.Reader;
import us.mtna.reader.ReaderImplDDI25;
import us.mtna.reader.ReaderImplEML211;
import us.mtna.reader.exceptions.ReaderException;
import us.mtna.reader.exceptions.RequestException;
import us.mtna.reader.exceptions.XmlValidationException;

public class DatasetManagerUtils {
    public static Reader getReaderImpl(XmlObject xmlObj) {
        ReaderImplDDI25 reader = null;
        if (xmlObj instanceof CodeBookDocument) {
            reader = new ReaderImplDDI25();
        } else if (xmlObj instanceof EmlDocument) {
            reader = new ReaderImplEML211();
        } else {
            throw new RequestException("XML type not recognized");
        }
        return reader;
    }

    public static XmlUpdater getUpdaterImpl(XmlObject xmlObj) {
        Ddi25XmlUpdater reader = null;
        if (xmlObj instanceof CodeBookDocument) {
            reader = new Ddi25XmlUpdater();
        } else if (xmlObj instanceof EmlDocument) {
            reader = new EmlUpdater();
        } else {
            throw new RequestException("XML type not recognized");
        }
        return reader;
    }

    public static XmlObject parseInputStream(InputStream xml) {
        try {
            return XmlObject.Factory.parse((InputStream)xml);
        }
        catch (IOException | XmlException e) {
            throw new ReaderException("Error reading input stream as XML ", e);
        }
    }

    public static XmlObject parseInputStream(MultipartFile xml) {
        try {
            XmlObject obj = XmlObject.Factory.parse((InputStream)xml.getInputStream());
            obj = DatasetManagerUtils.tryUpdatingVersion(obj);
            return obj;
        }
        catch (CharConversionException e) {
            throw new RequestException("Cannot read xml file due to unrecognized encoding.", (Throwable)e);
        }
        catch (IOException | XmlException e) {
            throw new ReaderException("Error reading input stream as XML ", e);
        }
    }

    public static void validate(XmlObject xml) {
        ArrayList errors = new ArrayList();
        if (!xml.validate(new XmlOptions().setErrorListener(errors))) {
            ((XmlError)errors.get(0)).getMessage();
        }
        if (!errors.isEmpty()) {
            throw new XmlValidationException(errors);
        }
    }

    public static XmlObject tryUpdatingVersion(XmlObject xml) {
        XmlAnyTypeImpl anyType;
        if (xml instanceof XmlAnyTypeImpl && (anyType = (XmlAnyTypeImpl)xml).xmlText().startsWith("<codeBook version=\"1.2.2")) {
            int fromIndex = anyType.xmlText().indexOf("codeBook");
            int endingIndex = anyType.xmlText().indexOf(62, fromIndex);
            String withoutHeader = anyType.xmlText().substring(endingIndex + 1, anyType.xmlText().length());
            String correctHeader = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<codeBook xmlns=\"ddi:codebook:2_5\" version=\"2.5\" ID=\"Temp3\" xml-lang=\"en\">\r\n";
            String newXmlText = correctHeader.concat(withoutHeader);
            try {
                XmlObject obj = XmlObject.Factory.parse((String)newXmlText);
                CodeBookDocument cbt = (CodeBookDocument)obj;
                return cbt;
            }
            catch (XmlException e) {
                throw new ReaderException("could not update ddi ", (Throwable)e);
            }
        }
        return xml;
    }
}

