/*
 * Decompiled with CFR 0.152.
 */
package us.mtna.dataset.updater.info.ws;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.springframework.web.multipart.MultipartFile;
import us.mtna.dataset.updater.exception.UpdaterException;
import us.mtna.dataset.updater.info.ws.DatasetInformationManager;
import us.mtna.pojo.DataSet;
import us.mtna.pojo.Variable;
import us.mtna.reader.Reader;
import us.mtna.reader.exceptions.XmlValidationException;

public class DatasetInformationManagerImpl
implements DatasetInformationManager {
    @Override
    public List<String> getVariableNames(MultipartFile file) {
        ArrayList<String> variableIds = new ArrayList<String>();
        for (DataSet ds : this.parseDatasets(file)) {
            variableIds.addAll(ds.getMetadata().getVarNameMap().keySet());
        }
        return variableIds;
    }

    @Override
    public List<String> getVariableIds(MultipartFile file) {
        ArrayList<String> variableNames = new ArrayList<String>();
        for (DataSet ds : this.parseDatasets(file)) {
            for (Variable v : ds.getMetadata().getVarNameMap().values()) {
                variableNames.add(v.getId());
            }
        }
        return variableNames;
    }

    @Override
    public List<Variable> getVariables(MultipartFile file) {
        ArrayList<Variable> variables = new ArrayList<Variable>();
        for (DataSet ds : this.parseDatasets(file)) {
            variables.addAll(ds.getMetadata().getVarNameMap().values());
        }
        return variables;
    }

    @Override
    public List<DataSet> getDataSets(MultipartFile file) {
        return this.parseDatasets(file);
    }

    private List<DataSet> parseDatasets(MultipartFile file) {
        try {
            XmlObject xml = Reader.getXmlObjectFromInputStream((InputStream)file.getInputStream());
            DatasetInformationManagerImpl.validateXml(xml);
            List datasets = Reader.getDataSets((XmlObject)xml);
            return datasets;
        }
        catch (IOException e) {
            throw new UpdaterException("File could not be parsed as XML.", e);
        }
    }

    public static void validateXml(XmlObject xml) {
        ArrayList errors = new ArrayList();
        xml.validate(new XmlOptions().setErrorListener(errors));
        if (!errors.isEmpty()) {
            throw new XmlValidationException(errors);
        }
    }
}

