/*
 * Decompiled with CFR 0.152.
 */
package us.mtna.dataset.updater.impl;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import us.mtna.data.transform.command.object.FileDetails;
import us.mtna.dataset.updater.DataSetManager;
import us.mtna.dataset.updater.exception.UnknownDataSetException;
import us.mtna.pojo.DataSet;
import us.mtna.reader.ResourceCopyUtility;

public class DefaultDataSetManager
implements DataSetManager {
    private LinkedHashMap<String, DataSet> datasets = new LinkedHashMap();

    public void mapDatasets(List<DataSet> datasets) {
        for (DataSet dataset : datasets) {
            if (dataset.getScriptName() == null) {
                if (dataset.getName() != null) {
                    this.datasets.put(dataset.getName(), dataset);
                    continue;
                }
                if (dataset.getDatasetId() != null) {
                    this.datasets.put(dataset.getDatasetId(), dataset);
                    continue;
                }
                if (dataset.getId() != null) {
                    this.datasets.put(dataset.getId(), dataset);
                    continue;
                }
                this.datasets.put(null, dataset);
                continue;
            }
            this.datasets.put(dataset.getScriptName(), dataset);
        }
    }

    public void mapDatasets(List<DataSet> datasets, DataSet primaryDataset) {
        this.datasets.put(primaryDataset.getId(), (DataSet)ResourceCopyUtility.copyResource(DataSet.class, (Object)primaryDataset));
        for (DataSet dataset : datasets) {
            this.datasets.put(dataset.getScriptName(), dataset);
        }
    }

    @Override
    public DataSet loadDataSet(String scriptName) {
        if (this.datasets.size() == 1) {
            return this.datasets.values().iterator().next();
        }
        DataSet dataSet = this.datasets.get(scriptName = scriptName.replaceAll("'", ""));
        if (dataSet != null) {
            return dataSet;
        }
        dataSet = this.matchDataSet(scriptName);
        if (dataSet == null) {
            throw new UnknownDataSetException(scriptName);
        }
        return dataSet;
    }

    public DataSet matchDataSet(String scriptName) throws UnknownDataSetException {
        DataSet matched = null;
        for (DataSet dataset : this.datasets.values()) {
            if (!dataset.getId().trim().equals(scriptName) && !dataset.getName().trim().equals(scriptName) && (dataset.getFile().getDocumentTitle() == null || !dataset.getFile().getDocumentTitle().trim().equals(scriptName)) && (dataset.getFile().getFileName() == null || !dataset.getFile().getFileName().trim().equals(scriptName))) continue;
            matched = dataset;
        }
        if (matched == null) {
            throw new UnknownDataSetException(scriptName);
        }
        return matched;
    }

    public DataSet loadDataSet(FileDetails file) throws UnknownDataSetException {
        if (this.datasets.get(file.getFileName()) != null) {
            return this.datasets.get(file.getFileName());
        }
        if (this.datasets.get(file.getFilePath()) != null) {
            return this.datasets.get(file.getFilePath());
        }
        if (this.datasets.get(file.getDocumentTitle()) != null) {
            return this.datasets.get(file.getDocumentTitle());
        }
        if (this.datasets.get(file.getExtension()) != null) {
            return this.datasets.get(file.getExtension());
        }
        if (this.datasets.get(file.getUri()) != null) {
            return this.datasets.get(file.getUri());
        }
        throw new UnknownDataSetException(file.toString());
    }

    @Override
    public void saveDataSet(DataSet dataSet) {
        DataSet copydataSet = (DataSet)ResourceCopyUtility.copyResource(DataSet.class, (Object)dataSet);
        this.datasets.put(copydataSet.getId(), copydataSet);
    }

    @Override
    public Collection<DataSet> getDataSets() {
        return this.datasets.values();
    }

    public DataSet getDataSet(String id) {
        return this.datasets.get(id);
    }

    @Override
    public void setDatasets(LinkedHashMap<String, DataSet> datasets) {
        this.datasets = datasets;
    }
}

