/*
 * Decompiled with CFR 0.152.
 */
package us.mtna.dataset.updater;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.c2metadata.sdtl.pojo.FunctionArgument;
import org.c2metadata.sdtl.pojo.expression.AllVariablesExpression;
import org.c2metadata.sdtl.pojo.expression.CompositeVariableNameExpression;
import org.c2metadata.sdtl.pojo.expression.ExpressionBase;
import org.c2metadata.sdtl.pojo.expression.FunctionCallExpression;
import org.c2metadata.sdtl.pojo.expression.GroupedExpression;
import org.c2metadata.sdtl.pojo.expression.MissingValueConstantExpression;
import org.c2metadata.sdtl.pojo.expression.NumericConstantExpression;
import org.c2metadata.sdtl.pojo.expression.StringConstantExpression;
import org.c2metadata.sdtl.pojo.expression.VariableListExpression;
import org.c2metadata.sdtl.pojo.expression.VariableRangeExpression;
import org.c2metadata.sdtl.pojo.expression.VariableReferenceBase;
import org.c2metadata.sdtl.pojo.expression.VariableSymbolExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.mtna.data.transform.command.CreatesVariables;
import us.mtna.data.transform.command.DeletesVariable;
import us.mtna.data.transform.command.SdtlWrapper;
import us.mtna.data.transform.command.SelectsVariables;
import us.mtna.data.transform.command.UpdatesClassification;
import us.mtna.data.transform.command.UpdatesVariables;
import us.mtna.data.transform.command.ds.AppendsDatasets;
import us.mtna.data.transform.command.ds.LoadsDataset;
import us.mtna.data.transform.command.ds.MergesDatasets;
import us.mtna.data.transform.command.ds.NonTransform;
import us.mtna.data.transform.command.ds.ReordersDataset;
import us.mtna.data.transform.command.ds.SavesDataset;
import us.mtna.data.transform.command.ds.UpdatesCases;
import us.mtna.data.transform.command.ds.UpdatesDataset;
import us.mtna.data.transform.command.object.ClassificationUpdate;
import us.mtna.data.transform.command.object.ClassificationUtils;
import us.mtna.data.transform.command.object.CodeDetail;
import us.mtna.data.transform.command.object.MinMax;
import us.mtna.data.transform.command.object.NewVariable;
import us.mtna.data.transform.command.object.Range;
import us.mtna.data.transform.command.object.UpdaterMergeFileDescription;
import us.mtna.data.transform.command.object.VariableNamePair;
import us.mtna.dataset.updater.CodeMappingUtility;
import us.mtna.dataset.updater.DataSetManager;
import us.mtna.dataset.updater.DataSetManagerFactory;
import us.mtna.dataset.updater.exception.MissingSourceVariableException;
import us.mtna.dataset.updater.exception.UnknownDataSetException;
import us.mtna.dataset.updater.impl.DefaultDataSetManagerFactory;
import us.mtna.pojo.Classification;
import us.mtna.pojo.Code;
import us.mtna.pojo.DataSet;
import us.mtna.pojo.DataType;
import us.mtna.pojo.FileTransform;
import us.mtna.pojo.Transform;
import us.mtna.pojo.Variable;
import us.mtna.reader.ResourceCopyUtility;

public class DataSetUpdater {
    private DataSet primaryDataset;
    private final DataSetManager dataSetManager;
    private boolean allowComputeClassifications;
    private Map<String, HashSet<String>> possibleCodes;
    private final HashMap<String, Variable> variableMap;
    private Logger log = LoggerFactory.getLogger(DataSetUpdater.class);
    private static DataSetManagerFactory managerFactory = new DefaultDataSetManagerFactory();

    public DataSetUpdater(DataSet primaryDataset, List<DataSet> datasets) {
        this.primaryDataset = primaryDataset;
        this.variableMap = new HashMap();
        this.possibleCodes = new HashMap<String, HashSet<String>>();
        this.dataSetManager = managerFactory.getInstance(datasets);
    }

    public DataSetUpdater(DataSet primaryDataset) {
        this(primaryDataset, Collections.emptyList());
    }

    public synchronized DataSet updateDataSet(SdtlWrapper wrapper, Transform transform) {
        UpdatesCases updatesCases;
        String[] stringArray = wrapper.getOriginalCommand().getUnknownProperties();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String property = stringArray[n2];
            this.log.info("Unknown property [" + property + "] found on command " + wrapper.getOriginalCommand().getCommand());
            ++n2;
        }
        this.variableMap.clear();
        if (LoadsDataset.class.isAssignableFrom(wrapper.getClass())) {
            LoadsDataset loads = (LoadsDataset)wrapper;
            this.primaryDataset = this.dataSetManager.loadDataSet(loads.getDatasetId());
            this.log.debug("Loading dataset [" + loads.getDatasetId() + "] and setting as the primary dataset.");
        }
        if (this.primaryDataset == null) {
            this.log.info("Primary dataset is null after performing dataset commands and the program cannot continue.");
            throw new UnknownDataSetException("Dataset is null after performing Dataset commands and the program cannot continue.");
        }
        if (CreatesVariables.class.isAssignableFrom(wrapper.getClass())) {
            CreatesVariables creates = (CreatesVariables)wrapper;
            transform = this.createVariables(creates, transform);
        }
        if (SelectsVariables.class.isAssignableFrom(wrapper.getClass())) {
            SelectsVariables selector = (SelectsVariables)wrapper;
            this.getSelectedVariables(selector, transform);
        }
        if (ReordersDataset.class.isAssignableFrom(wrapper.getClass())) {
            ReordersDataset reorders = (ReordersDataset)wrapper;
            this.reorderDataset(reorders, transform);
        }
        if (DeletesVariable.class.isAssignableFrom(wrapper.getClass())) {
            DeletesVariable deletes = (DeletesVariable)wrapper;
            this.markVariablesAsDeleted(transform, deletes);
        }
        if (MergesDatasets.class.isAssignableFrom(wrapper.getClass())) {
            MergesDatasets merges = (MergesDatasets)wrapper;
            this.matchByVariable(merges, transform);
            this.getSelectedVariables((SelectsVariables)wrapper, transform);
        }
        if (AppendsDatasets.class.isAssignableFrom(wrapper.getClass())) {
            AppendsDatasets appends = (AppendsDatasets)wrapper;
            this.appendDatasets(appends, transform);
            this.getSelectedVariables((SelectsVariables)wrapper, transform);
        }
        if (UpdatesVariables.class.isAssignableFrom(wrapper.getClass())) {
            UpdatesVariables updatesVar = (UpdatesVariables)wrapper;
            this.updateVariables(updatesVar);
        }
        if (UpdatesClassification.class.isAssignableFrom(wrapper.getClass())) {
            UpdatesClassification updatesClassif = (UpdatesClassification)wrapper;
            this.updateClassification(updatesClassif);
        }
        if (UpdatesCases.class.isAssignableFrom(wrapper.getClass())) {
            updatesCases = (UpdatesCases)wrapper;
            this.updateCases(updatesCases, transform);
        }
        if (UpdatesDataset.class.isAssignableFrom(wrapper.getClass())) {
            updatesCases = (UpdatesDataset)wrapper;
        }
        if (SavesDataset.class.isAssignableFrom(wrapper.getClass())) {
            SavesDataset saves = (SavesDataset)wrapper;
            this.saveDataset(saves, transform);
        }
        if (NonTransform.class.isAssignableFrom(wrapper.getClass())) {
            NonTransform nonTransform = (NonTransform)wrapper;
        }
        return this.primaryDataset;
    }

    private void updateCases(UpdatesCases updatesCases, Transform transform) {
        FileTransform fileTransform = new FileTransform(transform);
        fileTransform.setDropCases(true);
        this.primaryDataset.addCommands(new FileTransform[]{fileTransform});
    }

    private void reorderDataset(ReordersDataset reordersDataset, Transform transform) {
        ArrayList<Variable> newOrder = new ArrayList<Variable>();
        this.log.trace("Reordering dataset with command [" + transform.getOriginalCommand().getCommand() + "]");
        for (String variableName : reordersDataset.getVariableOrder()) {
            Variable variable = (Variable)this.primaryDataset.getMetadata().getVarNameMap().get(variableName);
            newOrder.add(variable);
        }
        if (!newOrder.isEmpty()) {
            this.primaryDataset.getMetadata().setVariables(newOrder);
        }
        FileTransform fileTransform = new FileTransform(transform);
        this.primaryDataset.addCommands(new FileTransform[]{fileTransform});
    }

    private void saveDataset(SavesDataset savesDataset, Transform transform) {
        this.log.trace("Saving dataset with ID [" + savesDataset.getDatasetId() + "]");
        this.primaryDataset.addCommands(new FileTransform[]{new FileTransform(transform)});
        this.dataSetManager.saveDataSet(this.primaryDataset);
    }

    private void appendDatasets(AppendsDatasets appendsDatasets, Transform transform) {
        LinkedHashMap<String, Variable> orderedVarMap = new LinkedHashMap<String, Variable>();
        DataSet newDataSet = new DataSet();
        FileTransform fileTransform = new FileTransform(transform);
        newDataSet.addCommands(new FileTransform[]{fileTransform});
        String[] stringArray = appendsDatasets.getFileNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String datasetId = stringArray[n2];
            DataSet dataset = this.dataSetManager.loadDataSet(datasetId);
            orderedVarMap.putAll(dataset.getMetadata().getVarNameMap());
            this.log.info("Appending variables from dataset [id=" + datasetId + "] into target dataset [" + newDataSet.getId() + "]");
            ++n2;
        }
        if (appendsDatasets.getAppendFlagVariable() != null) {
            Variable appendFlagVariable = new Variable();
            appendFlagVariable.setName(appendsDatasets.getAppendFlagVariable());
            appendFlagVariable.setClassificationId(UUID.randomUUID().toString());
            this.log.trace("Creating new append flag variable variable [id=" + appendFlagVariable.getName() + "]");
            orderedVarMap.put(appendsDatasets.getAppendFlagVariable(), appendFlagVariable);
        }
        newDataSet.getMetadata().setVariables(new LinkedList(orderedVarMap.values()));
        this.setPrimaryDataset(newDataSet);
    }

    private void matchByVariable(MergesDatasets merges, Transform transform) {
        DataSet ds = new DataSet();
        UpdaterMergeFileDescription.UpdateType updateType = null;
        HashMap datasetVars = new HashMap();
        for (UpdaterMergeFileDescription file : merges.getMergeFileDscr()) {
            updateType = file.getUpdate();
            LinkedHashSet<Variable> vars = new LinkedHashSet<Variable>();
            if (file.getFileName() == null) continue;
            ds = this.dataSetManager.loadDataSet(file.getFileName());
            for (Variable v : ds.getMetadata().getVarNameMap().values()) {
                vars.add(v);
            }
            if (file.getMergeFlagVariable() != null) {
                Variable v;
                v = new Variable();
                v.addTransforms(new Transform[]{transform});
                v.setName(file.getMergeFlagVariable());
                vars.add(v);
            }
            datasetVars.put(ds.getId(), vars);
        }
        Set matchByVars = merges.getMergeByVariables();
        LinkedHashMap<String, Variable> finalList = new LinkedHashMap<String, Variable>();
        for (Map.Entry entry : datasetVars.entrySet()) {
            for (Variable v : (LinkedHashSet)entry.getValue()) {
                if (finalList.keySet().contains(v.getName())) {
                    if (matchByVars.contains(v.getName())) continue;
                    switch (updateType) {
                        case REPLACE: {
                            finalList.put(v.getName(), v);
                            break;
                        }
                    }
                    continue;
                }
                finalList.put(v.getName(), v);
            }
        }
        FileTransform fileTransform = new FileTransform(transform);
        ds.getMetadata().setVariables(new LinkedList(finalList.values()));
        ds.addCommands(new FileTransform[]{fileTransform});
        this.setPrimaryDataset(ds);
    }

    private void keepAndDropVars(VariableReferenceBase[] keeps, VariableReferenceBase[] drops, Transform transform, Map<String, Variable> variableMap) {
        int n;
        int n2;
        VariableReferenceBase[] variableReferenceBaseArray;
        LinkedHashSet<String> keepVars = new LinkedHashSet<String>();
        LinkedHashSet<String> dropVars = new LinkedHashSet<String>();
        if (keeps != null) {
            variableReferenceBaseArray = keeps;
            n2 = keeps.length;
            n = 0;
            while (n < n2) {
                VariableReferenceBase keep = variableReferenceBaseArray[n];
                keepVars.addAll(this.parseExpressionBase((ExpressionBase)keep, variableMap));
                ++n;
            }
        }
        if (drops != null) {
            variableReferenceBaseArray = drops;
            n2 = drops.length;
            n = 0;
            while (n < n2) {
                VariableReferenceBase drop = variableReferenceBaseArray[n];
                dropVars.addAll(this.parseExpressionBase((ExpressionBase)drop, variableMap));
                ++n;
            }
        }
        if (!keepVars.isEmpty()) {
            for (Map.Entry<String, Variable> entry : variableMap.entrySet()) {
                if (keepVars.contains(entry.getKey())) continue;
                entry.getValue().setDeleted(true);
                entry.getValue().addTransforms(new Transform[]{transform});
            }
        }
        if (!dropVars.isEmpty()) {
            for (String s : dropVars) {
                if (variableMap.get(s) == null) continue;
                Variable v = variableMap.get(s);
                v.setDeleted(true);
                v.addTransforms(new Transform[]{transform});
            }
        }
    }

    private void getSelectedVariables(SelectsVariables selectCommand, Transform transform) {
        Map datasetVariableMap = this.primaryDataset.getMetadata().getVarNameMap();
        HashSet selectedVariables = new HashSet();
        if (selectCommand.getRanges() != null) {
            HashMap<String, Variable> selectedRanges = this.extractAndReturnRangeVariables(transform, selectCommand.getRanges(), datasetVariableMap);
            selectedVariables.addAll(selectedRanges.keySet());
        }
        if (selectCommand.getVariables() != null) {
            selectedVariables.addAll(selectCommand.getVariables());
        }
        for (String variableName : selectedVariables) {
            if (datasetVariableMap.get(variableName) == null) continue;
            List<Transform> transforms = Arrays.asList(((Variable)datasetVariableMap.get(variableName)).getTransforms());
            if (!transforms.contains(transform)) {
                ((Variable)datasetVariableMap.get(variableName)).addTransforms(new Transform[]{transform});
            }
            this.log.trace("Adding variable [name=" + variableName + "] to the variable list");
            this.variableMap.put(variableName, (Variable)datasetVariableMap.get(variableName));
        }
    }

    private HashMap<String, Variable> extractAndReturnRangeVariables(Transform transform, List<Range> ranges, Map<String, Variable> datasetVariableMap) {
        HashMap<String, Variable> variables = new HashMap<String, Variable>();
        for (Range range : ranges) {
            if (range.getStart() == null) continue;
            if (range.getEnd() != null) {
                for (Variable variable : this.primaryDataset.getVariablesInRange(range.getStart(), range.getEnd())) {
                    if (!new ArrayList<Transform>(Arrays.asList(variable.getTransforms())).contains(transform)) {
                        variable.addTransforms(new Transform[]{transform});
                    }
                    variables.put(variable.getName(), variable);
                }
                continue;
            }
            if (!new ArrayList<Transform>(Arrays.asList(datasetVariableMap.get(range.getStart()).getTransforms())).contains(transform)) {
                datasetVariableMap.get(range.getStart()).addTransforms(new Transform[]{transform});
            }
            variables.put(range.getStart(), datasetVariableMap.get(range.getStart()));
        }
        return variables;
    }

    /*
     * Unable to fully structure code
     */
    private Transform createVariables(CreatesVariables createsVariables, Transform transform) {
        fileTransform = new FileTransform(transform);
        newTransform = this.copyTransform(transform);
        var8_5 = createsVariables.getNewVariables();
        var7_6 = var8_5.length;
        var6_7 = 0;
        while (var6_7 < var7_6) {
            block6: {
                newVariable = var8_5[var6_7];
                if (this.allowComputeClassifications) {
                    this.addPossibleCodes(newVariable);
                }
                preserved = null;
                if (createsVariables.preserveOriginalVariable() && newVariable.getBasisVariableName() != null) {
                    preserved = this.createCopyOfBasisVariable(transform, newVariable, null);
                    preserved.setDeleted(true);
                    preserved.addTransforms(new Transform[]{transform});
                    this.primaryDataset.getMetadata().getFinalVariables().add(preserved);
                }
                newTransform.getSourceIds().clear();
                if (newVariable.getBasisVariableName() == null) break block6;
                variable = this.createCopyOfBasisVariable(newTransform, newVariable, preserved);
                ** GOTO lbl27
            }
            if (this.primaryDataset.getMetadata().getVarNameMap().containsKey(newVariable.getNewVariableName())) {
                this.populateVariableFromMetadata(newTransform, newVariable);
            } else {
                variable = this.createNewVariable(newTransform, newVariable);
lbl27:
                // 2 sources

                variable.addTransforms(new Transform[]{newTransform});
                variable.setName(newVariable.getNewVariableName());
                this.primaryDataset.getMetadata().getVariables().add(variable);
                this.primaryDataset.getMetadata().getVarNameMap().put(variable.getName(), variable);
                this.variableMap.put(variable.getName(), variable);
                this.log.trace("Registering variable [id=" + variable.getId() + "] in the metadata.");
                if (newVariable.getBasisVariableName() != null && newVariable.getNewVariableName() != null && !newVariable.getBasisVariableName().equals(newVariable.getNewVariableName())) {
                    fileTransform.getAddedVariables().add(variable.getId());
                    fileTransform.setSourceDataset(this.primaryDataset.getDatasetId());
                    this.primaryDataset.addCommands(new FileTransform[]{fileTransform});
                }
            }
            ++var6_7;
        }
        return newTransform;
    }

    private Transform copyTransform(Transform transform) {
        Transform newTransform = new Transform();
        newTransform.setAlternativeCommands(Arrays.asList(transform.getAlternativeCommands()));
        newTransform.setDescription(transform.getDescription());
        newTransform.setOriginalCommand(transform.getOriginalCommand());
        newTransform.setSourceIds(transform.getSourceIds());
        return newTransform;
    }

    private void addPossibleCodes(NewVariable newVariable) {
        HashSet<String> newVariableCodes = new HashSet<String>();
        for (String possibleCode : newVariable.getPossibleCodes()) {
            newVariableCodes.add(possibleCode);
        }
        if (this.possibleCodes.keySet().contains(newVariable.getNewVariableName())) {
            HashSet<String> existingCodes = this.possibleCodes.get(newVariable.getNewVariableName());
            existingCodes.addAll(newVariableCodes);
            this.possibleCodes.put(newVariable.getNewVariableName(), existingCodes);
        } else {
            this.possibleCodes.put(newVariable.getNewVariableName(), newVariableCodes);
        }
    }

    private Variable createNewVariable(Transform transform, NewVariable newVariable) {
        Variable variable = new Variable();
        variable.setClassificationId(UUID.randomUUID().toString());
        this.primaryDataset.getMetadata().getClassifs().put(variable.getClassificationId(), new Classification());
        this.addSourceVariablesFromRange(transform, newVariable);
        transform.addSourceIds(newVariable.getSourceVariables().toArray(new String[0]));
        this.log.trace("Creating new variable [id=" + variable.getId() + "] and registering its new classification in the metadata.");
        return variable;
    }

    private Variable populateVariableFromMetadata(Transform transform, NewVariable newVariable) {
        Variable variable = (Variable)this.primaryDataset.getMetadata().getVarNameMap().get(newVariable.getNewVariableName());
        this.checkForNullSourceVariable(transform, newVariable.getNewVariableName(), variable);
        this.addSourceVariablesFromRange(transform, newVariable);
        transform.addSourceIds(new String[]{((Variable)this.primaryDataset.getMetadata().getVarNameMap().get(newVariable.getNewVariableName())).getId()});
        variable.removeAllTransforms();
        variable.addTransforms(new Transform[]{transform});
        variable.setId(UUID.randomUUID().toString());
        variable.setName(newVariable.getNewVariableName());
        this.log.trace("Creating new variable with name [" + newVariable.getNewVariableName() + "]. A variable with the same name was found in the metadata, so a copy of that variable is being used as the basis");
        return variable;
    }

    private void addSourceVariablesFromRange(Transform transform, NewVariable newVariable) {
        if (newVariable.getSourceVariableRange() != null) {
            Range range = newVariable.getSourceVariableRange();
            List sourceVarsFromRange = this.primaryDataset.getVariablesInRange(range.getStart(), range.getEnd());
            for (Variable variable : sourceVarsFromRange) {
                transform.addSourceIds(new String[]{variable.getName()});
            }
        }
    }

    private Variable createCopyOfBasisVariable(Transform transform, NewVariable newVariable, Variable originalVariable) {
        if (originalVariable == null) {
            originalVariable = (Variable)this.primaryDataset.getMetadata().getVarNameMap().get(newVariable.getBasisVariableName());
        }
        Variable variableCopy = (Variable)ResourceCopyUtility.copyResource(Variable.class, (Object)originalVariable);
        this.checkForNullSourceVariable(transform, newVariable.getBasisVariableName(), variableCopy);
        variableCopy.setName(newVariable.getNewVariableName());
        variableCopy.setClassificationId(originalVariable.getClassificationId());
        variableCopy.removeAllTransforms();
        variableCopy.setDeleted(false);
        variableCopy.setId(UUID.randomUUID().toString());
        transform.addSourceIds(new String[]{originalVariable.getId()});
        this.log.trace("Creating a variable based on variable [name=" + newVariable.getBasisVariableName() + "] from the datset with properties from command [" + transform.getOriginalCommand().getCommand() + "]");
        return variableCopy;
    }

    private void checkForNullSourceVariable(Transform transform, String name, Variable variable) {
        if (variable == null) {
            this.log.warn("Variable [" + name + "] is null, cannot continue with recode");
            throw new MissingSourceVariableException("Variable [" + name + "] is null, cannot continue with recode.", name, transform.getOriginalCommand().getCommand());
        }
    }

    private void markVariablesAsDeleted(Transform transform, DeletesVariable deleteCommand) {
        Map datasetVariableMap = this.primaryDataset.getMetadata().getVarNameMap();
        FileTransform ft = new FileTransform(transform);
        transform.getSourceIds().add(this.primaryDataset.getDatasetId());
        HashMap<String, Variable> deletedRanges = this.extractAndReturnRangeVariables(transform, deleteCommand.getDeletedVariableRanges(), datasetVariableMap);
        HashSet<String> drops = new HashSet<String>();
        drops.addAll(deletedRanges.keySet());
        drops.addAll(deleteCommand.getDeletedVars());
        HashMap<String, Variable> keptRanges = this.extractAndReturnRangeVariables(transform, deleteCommand.getKeepVariableRanges(), datasetVariableMap);
        HashSet<String> keeps = new HashSet<String>();
        keeps.addAll(keptRanges.keySet());
        keeps.addAll(deleteCommand.getKeepVars());
        for (String string : datasetVariableMap.keySet()) {
            if (keeps.isEmpty() || keeps.contains(string)) continue;
            drops.add(string);
        }
        for (Map.Entry entry : datasetVariableMap.entrySet()) {
            if (!drops.contains(entry.getKey())) continue;
            Variable variable = (Variable)entry.getValue();
            if (variable != null) {
                variable.setDeleted(true);
                this.log.trace("Setting variable [name=" + variable.getName() + "] as deleted.");
                continue;
            }
            this.log.debug("Attempted to delete variable [name=" + (String)entry.getKey() + "] but it could not be found.");
        }
        for (String string : drops) {
            ft.getDroppedVariables().add(string);
        }
        for (String string : keeps) {
            ft.getKeptVariables().add(string);
        }
        this.primaryDataset.addCommands(new FileTransform[]{ft});
    }

    private void updateVariables(UpdatesVariables updatesVariables) {
        for (Variable variable : this.variableMap.values()) {
            if (updatesVariables.getUpdatedVariables() != null) {
                VariableNamePair[] variableNamePairArray = updatesVariables.getUpdatedVariables();
                int n = variableNamePairArray.length;
                int n2 = 0;
                while (n2 < n) {
                    VariableNamePair pair = variableNamePairArray[n2];
                    if (variable.getName().equals(pair.getSource())) {
                        variable.setName(pair.getTarget());
                        if (pair.getLabel() != null) {
                            variable.setLabel(pair.getLabel());
                        }
                    }
                    ++n2;
                }
                continue;
            }
            this.log.debug("The list of variables to update is null.");
        }
    }

    private void updateClassification(UpdatesClassification updateClassification) {
        ClassificationUpdate update = updateClassification.getUpdate();
        ArrayList<String> usedCodes = new ArrayList<String>();
        for (Variable variable : this.variableMap.values()) {
            if (variable == null) {
                variable = new Variable();
            }
            Classification classification = this.determineClassificationToUse(updateClassification, variable);
            this.checkForDataTypeChange(variable, classification);
            this.removeCodes(update, usedCodes, classification);
            this.updateCodes(update, usedCodes, classification);
            this.addCodes(update, usedCodes, classification);
            if (updateClassification.copyFloatingCodes()) continue;
            List untouched = ClassificationUtils.getUntouchedCodes((Classification)classification, usedCodes);
            for (Code code : untouched) {
                classification.removeCode(code.getCodeValue());
                this.log.trace("UpdatesClassification: Removing unused code [" + code.getCodeValue() + "] from classification [" + classification.getId() + "]. (Floating codes are set to not be carried over.)");
            }
        }
    }

    private void checkForDataTypeChange(Variable variable, Classification classification) {
        DataType variableType;
        boolean numericCodes = false;
        if (!classification.getCodeList().isEmpty() && StringUtils.isNumeric((CharSequence)((Code)classification.getCodeList().get(0)).getCodeValue())) {
            numericCodes = true;
        }
        if ((variableType = variable.getDataType()) == DataType.STRING && numericCodes) {
            variable.setDataType(DataType.NUMBER);
        } else if (variableType == DataType.NUMBER && !numericCodes) {
            variable.setDataType(DataType.STRING);
        }
    }

    private Classification determineClassificationToUse(UpdatesClassification updatesClassification, Variable variable) {
        Classification classification;
        if (updatesClassification.requiresCopyOfClassification()) {
            if (!this.possibleCodes.keySet().contains(variable.getName())) {
                Classification oldClassif = this.primaryDataset.getMetadata().lookupClassificationById(variable.getClassificationId()) == null ? new Classification() : this.primaryDataset.getMetadata().lookupClassificationById(variable.getClassificationId());
                classification = (Classification)ResourceCopyUtility.copyResource(Classification.class, (Object)oldClassif);
                classification.setId(UUID.randomUUID().toString());
                this.primaryDataset.getMetadata().getClassifs().put(classification.getId(), classification);
                variable.setClassification(classification);
                this.log.trace("UpdatesClassification requires a new classification, so new classification [" + classification.getId() + "] was created and registered in the metadata .");
            } else {
                Classification classification2 = classification = this.primaryDataset.getMetadata().getClassifs().keySet().contains(variable.getClassificationId()) ? (Classification)this.primaryDataset.getMetadata().getClassifs().get(variable.getClassificationId()) : new Classification();
                if (this.possibleCodes.get(variable.getName()) != null) {
                    HashSet<String> codesToUse = this.possibleCodes.get(variable.getName());
                    ArrayList<Code> codesToAdd = new ArrayList<Code>();
                    for (String codeValue : codesToUse) {
                        Code code = new Code();
                        code.setCodeValue(codeValue);
                        codesToAdd.add(code);
                    }
                    classification.addCodesToCodeList(codesToAdd);
                }
                classification.setId(UUID.randomUUID().toString());
                variable.setClassificationId(classification.getId());
                variable.setClassification(classification);
                this.primaryDataset.getMetadata().getClassifs().put(classification.getId(), classification);
            }
        } else {
            classification = this.primaryDataset.getMetadata().lookupClassificationById(variable.getClassificationId()) == null ? new Classification() : this.primaryDataset.getMetadata().lookupClassificationById(variable.getClassificationId());
            this.log.trace("New classification not required for UpdatesClassification, so classification [" + classification.getId() + "] pulled from the metadata to be updated.");
        }
        return classification;
    }

    private void updateCodes(ClassificationUpdate classificationUpdate, List<String> usedCodes, Classification classification) {
        int n;
        int n2;
        CodeDetail[] codeDetailArray;
        if (classificationUpdate.getUpdatesCodes() != null) {
            codeDetailArray = classificationUpdate.getUpdatesCodes();
            n2 = codeDetailArray.length;
            n = 0;
            while (n < n2) {
                Code code;
                CodeDetail codeDetail = codeDetailArray[n];
                if (!classification.getCodeList().contains(codeDetail.getFromValue())) {
                    if (this.allowComputeClassifications && this.possibleCodes.containsKey(codeDetail.getFromValue())) {
                        classification.addNewCode(this.createCode(codeDetail));
                    }
                    if (codeDetail.getFromValue() == null) {
                        classification.addNewCode(this.createCode(codeDetail));
                    }
                }
                if ((code = classification.lookupCode(codeDetail.getFromValue())) == null) {
                    this.log.trace("UpdatesClassification: no match found when looking up code [" + codeDetail.getFromValue() + "] in classification [" + classification.getId() + "]. Looking up code value numerically");
                    CodeMappingUtility mappingUtility = CodeMappingUtility.getInstance(classification);
                    List<Code> numericallyMatchedCodes = mappingUtility.lookupNumericCode(codeDetail.getFromValue());
                    for (Code c : numericallyMatchedCodes) {
                        this.log.trace("UpdatesClassification: updating code [" + c.getCodeValue() + "].");
                        this.updateCode(c, codeDetail.getLabel(), codeDetail.isMissing(), codeDetail.getMissingType());
                        usedCodes.add(c.getCodeValue());
                    }
                } else {
                    this.log.trace("UpdatesClassification: updating code [" + code.getCodeValue() + "].");
                    this.updateCode(code, codeDetail.getLabel(), codeDetail.isMissing(), codeDetail.getMissingType());
                    usedCodes.add(code.getCodeValue());
                }
                ++n;
            }
        }
        if (classificationUpdate.getUpdatesCodeRange() != null) {
            codeDetailArray = classificationUpdate.getUpdatesCodeRange();
            n2 = codeDetailArray.length;
            n = 0;
            while (n < n2) {
                CodeDetail rangeDetail = codeDetailArray[n];
                for (Code code : classification.selectCodeRange(rangeDetail.getFromRange().getStart(), rangeDetail.getFromRange().getEnd())) {
                    this.log.trace("UpdatesClassification: updating code [" + code.getCodeValue() + "].");
                    this.updateCode(code, rangeDetail.getLabel(), rangeDetail.isMissing(), rangeDetail.getMissingType());
                    usedCodes.add(code.getCodeValue());
                }
                ++n;
            }
        }
        if (classificationUpdate.getUpdatesCodes() != null && classificationUpdate.getUpdatesCodeRange() != null) {
            this.log.trace("UpdatesClassification: no codes found to update.");
        }
    }

    private void removeCodes(ClassificationUpdate classificationUpdate, List<String> usedCodes, Classification classification) {
        int n;
        int n2;
        String[] stringArray;
        if (classificationUpdate.getRemovedCodes() != null) {
            stringArray = classificationUpdate.getRemovedCodes();
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                String codeValue = stringArray[n];
                classification.removeCode(codeValue);
                usedCodes.add(codeValue);
                this.log.trace("UpdatesClassification: removing code [" + codeValue + "].");
                ++n;
            }
        }
        if (classificationUpdate.getRemovedCodeRanges() != null) {
            stringArray = classificationUpdate.getRemovedCodeRanges();
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                String range = stringArray[n];
                if (range.getEnd().equals(MinMax.MAXIMUM.getValue()) && !classification.getCodeList().isEmpty()) {
                    range.setEnd(((Code)classification.getCodeList().get(classification.getCodeList().size() - 1)).getCodeValue());
                }
                if (range.getStart().equals(MinMax.MINIMUM.getValue()) && !classification.getCodeList().isEmpty()) {
                    range.setStart(((Code)classification.getCodeList().get(0)).getCodeValue());
                }
                for (Code code : classification.selectCodeRange(range.getStart(), range.getEnd())) {
                    classification.removeCode(code.getCodeValue());
                    usedCodes.add(code.getCodeValue().trim());
                    this.log.trace("UpdatesClassification: removing code [" + code.getCodeValue() + "].");
                }
                ++n;
            }
        }
        if (classificationUpdate.getRemovedCodeRanges() == null && classificationUpdate.getRemovedCodes() == null) {
            this.log.trace("UpdatesClassification: no codes found to remove.");
        }
    }

    private void addCodes(ClassificationUpdate update, List<String> usedCodes, Classification classification) {
        Code code;
        int n;
        int n2;
        CodeDetail[] codeDetailArray;
        if (update.getNewCodes() != null) {
            codeDetailArray = update.getNewCodes();
            n2 = codeDetailArray.length;
            n = 0;
            while (n < n2) {
                CodeDetail codeDetail = codeDetailArray[n];
                code = this.createCode(codeDetail);
                classification.addNewCode(code);
                usedCodes.add(code.getCodeValue());
                this.log.trace("UpdatesClassification: creating code [" + code.getCodeValue() + "].");
                ++n;
            }
        }
        if (update.getNewCodeRanges() != null) {
            codeDetailArray = update.getNewCodeRanges();
            n2 = codeDetailArray.length;
            n = 0;
            while (n < n2) {
                CodeDetail rangeDetail = codeDetailArray[n];
                code = this.createCode(new CodeDetail(rangeDetail.getTargetValue(), rangeDetail.getLabel(), rangeDetail.isMissing()));
                classification.addNewCode(code);
                usedCodes.add(code.getCodeValue());
                this.log.trace("UpdatesClassification: creating code [" + code.getCodeValue() + "].");
                ++n;
            }
        }
        if (update.getNewCodes() == null && update.getNewCodeRanges() == null) {
            this.log.trace("UpdatesClassification: no new codes created.");
        }
    }

    private void updateCode(Code code, String label, boolean missing, String missingType) {
        code.setLabel(label);
        code.setMissing(missing);
    }

    private Code createCode(CodeDetail codeDetail) {
        Code code = new Code();
        if (codeDetail.getNewValue() != null) {
            code.setCodeValue(codeDetail.getNewValue());
        }
        if (codeDetail.getLabel() != null) {
            code.setLabel(codeDetail.getLabel());
        }
        code.setMissing(codeDetail.isMissing());
        return code;
    }

    public Logger getLog() {
        return this.log;
    }

    public void setLog(Logger log) {
        this.log = log;
    }

    public static void setDataSetManagerFactory(DataSetManagerFactory managerFactory) {
        DataSetUpdater.managerFactory = managerFactory;
    }

    public void setPrimaryDataset(DataSet dataset) {
        this.primaryDataset = dataset;
    }

    public DataSet getPrimaryDataset() {
        return this.primaryDataset;
    }

    public boolean isAllowComputeClassifications() {
        return this.allowComputeClassifications;
    }

    public void setAllowComputeClassifications(boolean allowComputeClassifications) {
        this.allowComputeClassifications = allowComputeClassifications;
    }

    public Map<String, HashSet<String>> getPossibleCodes() {
        return this.possibleCodes;
    }

    public void setPossibleCodes(Map<String, HashSet<String>> possibleCodes) {
        this.possibleCodes = possibleCodes;
    }

    public DataSetManager getDataSetManager() {
        return this.dataSetManager;
    }

    private LinkedHashSet<String> parseExpressionBase(ExpressionBase expression, Map<String, Variable> varMap) {
        LinkedHashSet<String> vars = new LinkedHashSet<String>();
        if (expression != null) {
            if (VariableSymbolExpression.class.isAssignableFrom(expression.getClass())) {
                VariableSymbolExpression expr = (VariableSymbolExpression)expression;
                vars.add(expr.getVariableName());
            } else if (VariableRangeExpression.class.isAssignableFrom(expression.getClass())) {
                VariableRangeExpression expr = (VariableRangeExpression)expression;
                List<Variable> vasr = this.getVariablesInRange(expr.getFirst(), expr.getLast(), varMap);
                for (Variable v : vasr) {
                    vars.add(v.getName());
                }
            } else if (VariableListExpression.class.isAssignableFrom(expression.getClass())) {
                VariableListExpression expr = (VariableListExpression)expression;
                VariableReferenceBase[] variableReferenceBaseArray = expr.getVariables();
                int n = variableReferenceBaseArray.length;
                int n2 = 0;
                while (n2 < n) {
                    VariableReferenceBase base = variableReferenceBaseArray[n2];
                    vars.addAll(this.parseExpressionBase((ExpressionBase)base, varMap));
                    ++n2;
                }
            } else if (FunctionCallExpression.class.isAssignableFrom(expression.getClass())) {
                FunctionCallExpression expr = (FunctionCallExpression)expression;
                FunctionArgument[] functionArgumentArray = expr.getArguments();
                int n = functionArgumentArray.length;
                int n3 = 0;
                while (n3 < n) {
                    FunctionArgument eb = functionArgumentArray[n3];
                    vars.addAll(this.parseExpressionBase(eb.getArgumentValue(), varMap));
                    ++n3;
                }
            } else if (GroupedExpression.class.isAssignableFrom(expression.getClass())) {
                GroupedExpression expr = (GroupedExpression)expression;
                vars.addAll(this.parseExpressionBase(expr.getExpression(), varMap));
            } else if (NumericConstantExpression.class.isAssignableFrom(expression.getClass())) {
                NumericConstantExpression expr = (NumericConstantExpression)expression;
                vars.add(String.valueOf(expr.getValue()));
            } else if (MissingValueConstantExpression.class.isAssignableFrom(expression.getClass())) {
                MissingValueConstantExpression expr = (MissingValueConstantExpression)expression;
                vars.add(String.valueOf(expr.getValue()));
            } else if (StringConstantExpression.class.isAssignableFrom(expression.getClass())) {
                StringConstantExpression expr = (StringConstantExpression)expression;
                vars.add(expr.getValue());
            } else if (CompositeVariableNameExpression.class.isAssignableFrom(expression.getClass())) {
                CompositeVariableNameExpression composite = (CompositeVariableNameExpression)expression;
                vars.addAll(this.parseExpressionBase(composite.getComputedVariableName(), varMap));
            } else if (AllVariablesExpression.class.isAssignableFrom(expression.getClass())) {
                vars.addAll(varMap.keySet());
            }
        }
        return vars;
    }

    public List<Variable> getVariablesInRange(String from, String to, Map<String, Variable> originalMap) {
        ArrayList<Variable> vars = new ArrayList<Variable>();
        HashMap<String, Variable> varMap = new HashMap<String, Variable>();
        for (Map.Entry<String, Variable> entry : originalMap.entrySet()) {
            varMap.put(entry.getKey().toUpperCase(), entry.getValue());
        }
        boolean useStartPosition = true;
        for (Variable variable : varMap.values()) {
            if (variable.getStartPosition() != null) continue;
            useStartPosition = false;
            break;
        }
        ArrayList<Variable> sortedVars = new ArrayList<Variable>(originalMap.values());
        if (useStartPosition) {
            Collections.sort(sortedVars, Variable.StartPositionComparator);
        }
        Variable mapFirst = (Variable)varMap.get(from.toUpperCase());
        Variable mapLast = (Variable)varMap.get(to.toUpperCase());
        int toIndex = sortedVars.indexOf(mapLast);
        int fromIndex = sortedVars.indexOf(mapFirst);
        List subList = sortedVars.subList(fromIndex, toIndex + 1);
        for (Variable variable : subList) {
            vars.add(variable);
        }
        return vars;
    }
}

