/*
 * Decompiled with CFR 0.152.
 */
package us.mtna.dataset.updater;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.c2metadata.sdtl.pojo.Program;
import org.c2metadata.sdtl.pojo.command.TransformBase;
import org.ddialliance.ddi_2_5.xml.xmlbeans.CodeBookDocument;
import org.ecoinformatics.eml_2_1_1.xml.xmlbeans.EmlDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.mtna.c2metadata.xml.XmlUpdater;
import us.mtna.data.transform.command.SdtlWrapper;
import us.mtna.data.transform.wrapper.sdtl.ValidationResult;
import us.mtna.data.transform.wrapper.sdtl.WrapperFactory;
import us.mtna.dataset.updater.DataSetUpdater;
import us.mtna.dataset.updater.DatasetManagerUtils;
import us.mtna.dataset.updater.DdiManager;
import us.mtna.dataset.updater.InputInformation;
import us.mtna.dataset.updater.ValidationUtility;
import us.mtna.dataset.updater.exception.InvalidSdtlException;
import us.mtna.dataset.updater.impl.PseudocodeWebServiceImpl;
import us.mtna.pojo.DataSet;
import us.mtna.pojo.Transform;
import us.mtna.pojo.file.matching.FileMatcher;
import us.mtna.reader.Reader;
import us.mtna.reader.exceptions.RequestException;
import us.mtna.transform.cogs.json.PseudocodeService;
import us.mtna.transform.cogs.json.TransformMapper;
import us.mtna.updater.Author;
import us.mtna.updater.DatasetMetadata;

public class Ddi25OutputGenerator {
    private static Logger log = LoggerFactory.getLogger(Ddi25OutputGenerator.class);
    private boolean validate = true;
    private String updaterVersion;
    private PseudocodeService pseudocodeService;

    public String getUpdatedXmlAsString(Program sdtl, InputStream xml) {
        return this.produceDDI(sdtl, (XmlObject)new DdiManager().createNewDocument(this.parse(xml))).xmlText();
    }

    @Deprecated
    public String getUpdatedXmlAsString(Program sdtl, InputStream xml, FileMatcher matcher) {
        return this.produceDDI(sdtl, (XmlObject)new DdiManager().createNewDocument(this.parse(xml))).xmlText();
    }

    public String getUpdatedXmlAsString(InputInformation[] fileInformation, Program program, List<DataSet> datasets, XmlObject xmlObject) {
        return this.produceDDIWithDsMap(fileInformation, program, datasets, xmlObject).xmlText(new XmlOptions().setLoadStripWhitespace());
    }

    public InputStream getUpdatedXmlAsStream(Program sdtl, InputStream xml) {
        return this.produceDDI(sdtl, (XmlObject)new DdiManager().createNewDocument(this.parse(xml))).newInputStream();
    }

    @Deprecated
    public InputStream getUpdatedXmlAsStream(Program sdtl, InputStream xml, FileMatcher matcher) {
        return this.produceDDI(sdtl, (XmlObject)new DdiManager().createNewDocument(this.parse(xml))).newInputStream();
    }

    public String getUpdatedXmlAsString(Program sdtl, InputStream ... xml) {
        return this.produceDDIMultiDocumemnt(sdtl, xml).xmlText();
    }

    @Deprecated
    public String getUpdatedXmlAsString(Program sdtl, FileMatcher matcher, InputStream ... xml) {
        return this.produceDDIMultiDocumemnt(sdtl, xml).xmlText();
    }

    public InputStream getUpdatedXmlAsStream(Program sdtl, InputStream ... xml) {
        return this.produceDDIMultiDocumemnt(sdtl, xml).newInputStream();
    }

    @Deprecated
    public InputStream getUpdatedXmlAsStream(Program sdtl, FileMatcher matcher, InputStream ... xml) {
        return this.produceDDIMultiDocumemnt(sdtl, xml).newInputStream();
    }

    protected XmlObject produceDDIMultiDocumemnt(Program sdtlProgram, InputStream ... inputs) {
        LinkedList<XmlObject> objects = new LinkedList<XmlObject>();
        InputStream[] inputStreamArray = inputs;
        int n = inputs.length;
        int n2 = 0;
        while (n2 < n) {
            InputStream stream = inputStreamArray[n2];
            objects.add(DatasetManagerUtils.parseInputStream(stream));
            ++n2;
        }
        XmlObject xmlObject = (XmlObject)objects.get(0);
        if (inputs.length > 1) {
            if (xmlObject instanceof CodeBookDocument) {
                return this.produceDDI(sdtlProgram, (XmlObject)new DdiManager().merge(objects.toArray(new XmlObject[0])));
            }
            if (xmlObject instanceof EmlDocument) {
                throw new RequestException("More than one EML document was found, and EML merging is not yet available. Please consolidate your datasets into one file if possible.");
            }
        } else {
            if (inputs.length == 1) {
                return this.produceDDI(sdtlProgram, xmlObject);
            }
            throw new RequestException("No XML found");
        }
        return null;
    }

    protected CodeBookDocument parse(InputStream xml) {
        XmlObject xmlObject = DatasetManagerUtils.parseInputStream(xml);
        DatasetManagerUtils.validate(xmlObject);
        return (CodeBookDocument)xmlObject;
    }

    protected XmlObject produceDDI(Program sdtlProgram, XmlObject xml) {
        log.trace("Preparing to read xml into dataset objects");
        Reader reader = DatasetManagerUtils.getReaderImpl(xml);
        List readerDataSets = reader.getDataSets(xml);
        return this.produceDDIWithDsMap(null, sdtlProgram, readerDataSets, xml);
    }

    protected XmlObject produceDDIWithDsMap(InputInformation[] fileInformation, Program program, List<DataSet> datasets, XmlObject originalXml) {
        ValidationResult result;
        log.trace("Preparing to read xml into dataset objects");
        DataSet primary = datasets.get(0);
        DataSetUpdater datasetUpdater = new DataSetUpdater(primary, datasets);
        if (this.validate && !(result = ValidationUtility.validate(program)).isValid()) {
            String language = program.getSourceLanguage() != null ? program.getSourceLanguage() : "";
            throw new InvalidSdtlException((List<String>)result.getMessages(), language);
        }
        ObjectMapper mapper = new ObjectMapper();
        if (this.pseudocodeService == null) {
            this.pseudocodeService = new PseudocodeWebServiceImpl();
        }
        for (TransformBase base : program.getCommands()) {
            String command;
            log.trace("preparing to update with command " + (base.getSourceInformation() != null ? base.getSourceInformation().getOriginalSourceText() : "[no source provided]"));
            SdtlWrapper wrapper = WrapperFactory.wrap((TransformBase)base);
            try {
                command = this.pseudocodeService.generate(mapper.writeValueAsString((Object)base));
            }
            catch (JsonProcessingException e) {
                command = "Unable to retreive pseudocode.";
            }
            Transform transform = TransformMapper.mapTransformBase((TransformBase)base, (String)program.getSourceLanguage(), (String)command);
            datasetUpdater.updateDataSet(wrapper, transform);
        }
        XmlUpdater updater = DatasetManagerUtils.getUpdaterImpl(originalXml);
        updater.setLog(log);
        updater.setDatasetMetadata(this.populateDatasetMetadata(fileInformation));
        return updater.updateXml(originalXml, new DataSet[]{primary});
    }

    private DatasetMetadata populateDatasetMetadata(InputInformation[] fileInformation) {
        DatasetMetadata metadata = new DatasetMetadata();
        if (fileInformation != null) {
            InputInformation[] inputInformationArray = fileInformation;
            int n = fileInformation.length;
            int n2 = 0;
            while (n2 < n) {
                InputInformation info = inputInformationArray[n2];
                if (info != null) {
                    if (info.getTitle() != null) {
                        metadata.setDocumentTitle(info.getTitle());
                    }
                    if (info.getAuthor() != null) {
                        Author author = new Author();
                        author.setFirstName(info.getAuthor());
                        metadata.getAuthors().add(author);
                    }
                }
                ++n2;
            }
        }
        return metadata;
    }

    public void setPseudocodeService(PseudocodeService service) {
        this.pseudocodeService = service;
        TransformMapper.setPseudocodeService((PseudocodeService)service);
    }

    public void setValidation(boolean validate) {
        this.validate = validate;
    }

    public static Logger getLog() {
        return log;
    }

    public static void setLog(Logger log) {
        Ddi25OutputGenerator.log = log;
    }

    public String getUpdaterVersion() {
        return this.updaterVersion;
    }

    public void setUpdaterVersion(String updaterVersion) {
        this.updaterVersion = updaterVersion;
    }
}

